rule win_qhost_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.qhost."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.qhost"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { b8???????? eb0c 8b4dfc 51 ff15???????? }
            // n = 5, score = 100
            //   b8????????           |                     
            //   eb0c                 | jmp                 0xe
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   51                   | push                ecx
            //   ff15????????         |                     

        $sequence_1 = { 6a04 8d55f0 52 6a07 8b4508 50 }
            // n = 6, score = 100
            //   6a04                 | push                4
            //   8d55f0               | lea                 edx, [ebp - 0x10]
            //   52                   | push                edx
            //   6a07                 | push                7
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   50                   | push                eax

        $sequence_2 = { 50 68???????? 68???????? 680f270000 68???????? }
            // n = 5, score = 100
            //   50                   | push                eax
            //   68????????           |                     
            //   68????????           |                     
            //   680f270000           | push                0x270f
            //   68????????           |                     

        $sequence_3 = { 7430 6a00 6a02 8d55f8 52 6a23 ff55fc }
            // n = 7, score = 100
            //   7430                 | je                  0x32
            //   6a00                 | push                0
            //   6a02                 | push                2
            //   8d55f8               | lea                 edx, [ebp - 8]
            //   52                   | push                edx
            //   6a23                 | push                0x23
            //   ff55fc               | call                dword ptr [ebp - 4]

        $sequence_4 = { 894da0 8b55a0 3b55a4 0f8d56040000 8d459c }
            // n = 5, score = 100
            //   894da0               | mov                 dword ptr [ebp - 0x60], ecx
            //   8b55a0               | mov                 edx, dword ptr [ebp - 0x60]
            //   3b55a4               | cmp                 edx, dword ptr [ebp - 0x5c]
            //   0f8d56040000         | jge                 0x45c
            //   8d459c               | lea                 eax, [ebp - 0x64]

        $sequence_5 = { 6880000000 6a00 8d8d74feffff 51 e8???????? 83c40c 8b9570feffff }
            // n = 7, score = 100
            //   6880000000           | push                0x80
            //   6a00                 | push                0
            //   8d8d74feffff         | lea                 ecx, [ebp - 0x18c]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8b9570feffff         | mov                 edx, dword ptr [ebp - 0x190]

        $sequence_6 = { e8???????? 83c404 e9???????? 83bd68ffffff06 7536 83bd6cffffff00 752d }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   e9????????           |                     
            //   83bd68ffffff06       | cmp                 dword ptr [ebp - 0x98], 6
            //   7536                 | jne                 0x38
            //   83bd6cffffff00       | cmp                 dword ptr [ebp - 0x94], 0
            //   752d                 | jne                 0x2f

        $sequence_7 = { 52 8b45fc 50 ff15???????? eb4a }
            // n = 5, score = 100
            //   52                   | push                edx
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   eb4a                 | jmp                 0x4c

        $sequence_8 = { 8b8ddcfdffff 51 ff15???????? 83c404 8b95ecfdffff 52 e8???????? }
            // n = 7, score = 100
            //   8b8ddcfdffff         | mov                 ecx, dword ptr [ebp - 0x224]
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   83c404               | add                 esp, 4
            //   8b95ecfdffff         | mov                 edx, dword ptr [ebp - 0x214]
            //   52                   | push                edx
            //   e8????????           |                     

        $sequence_9 = { 50 6800040000 8d8d00fcffff 51 8b95c8fbffff 52 }
            // n = 6, score = 100
            //   50                   | push                eax
            //   6800040000           | push                0x400
            //   8d8d00fcffff         | lea                 ecx, [ebp - 0x400]
            //   51                   | push                ecx
            //   8b95c8fbffff         | mov                 edx, dword ptr [ebp - 0x438]
            //   52                   | push                edx

    condition:
        7 of them and filesize < 286720
}