rule win_qtbot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.qtbot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.qtbot"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b4510 89450c 8d4301 0fb6d8 8a941dfcfeffff }
            // n = 5, score = 200
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   89450c               | mov                 dword ptr [ebp + 0xc], eax
            //   8d4301               | lea                 eax, [ebx + 1]
            //   0fb6d8               | movzx               ebx, al
            //   8a941dfcfeffff       | mov                 dl, byte ptr [ebp + ebx - 0x104]

        $sequence_1 = { 33c0 53 8a1a 6bc80d }
            // n = 4, score = 200
            //   33c0                 | xor                 eax, eax
            //   53                   | push                ebx
            //   8a1a                 | mov                 bl, byte ptr [edx]
            //   6bc80d               | imul                ecx, eax, 0xd

        $sequence_2 = { 0fb6c3 83c0d0 03c1 25ffffff00 42 8a1a }
            // n = 6, score = 200
            //   0fb6c3               | movzx               eax, bl
            //   83c0d0               | add                 eax, -0x30
            //   03c1                 | add                 eax, ecx
            //   25ffffff00           | and                 eax, 0xffffff
            //   42                   | inc                 edx
            //   8a1a                 | mov                 bl, byte ptr [edx]

        $sequence_3 = { 33f6 8bde 85ff 7455 8b4510 89450c }
            // n = 6, score = 200
            //   33f6                 | xor                 esi, esi
            //   8bde                 | mov                 ebx, esi
            //   85ff                 | test                edi, edi
            //   7455                 | je                  0x57
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   89450c               | mov                 dword ptr [ebp + 0xc], eax

        $sequence_4 = { 84db 75e9 5b 5d }
            // n = 4, score = 200
            //   84db                 | test                bl, bl
            //   75e9                 | jne                 0xffffffeb
            //   5b                   | pop                 ebx
            //   5d                   | pop                 ebp

        $sequence_5 = { 64a130000000 8b400c 8b7014 ad 8b00 8b4010 }
            // n = 6, score = 200
            //   64a130000000         | mov                 eax, dword ptr fs:[0x30]
            //   8b400c               | mov                 eax, dword ptr [eax + 0xc]
            //   8b7014               | mov                 esi, dword ptr [eax + 0x14]
            //   ad                   | lodsd               eax, dword ptr [esi]
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   8b4010               | mov                 eax, dword ptr [eax + 0x10]

        $sequence_6 = { 742a 8b049a 03c6 50 e8???????? 3b4508 740b }
            // n = 7, score = 200
            //   742a                 | je                  0x2c
            //   8b049a               | mov                 eax, dword ptr [edx + ebx*4]
            //   03c6                 | add                 eax, esi
            //   50                   | push                eax
            //   e8????????           |                     
            //   3b4508               | cmp                 eax, dword ptr [ebp + 8]
            //   740b                 | je                  0xd

        $sequence_7 = { 88841dfcfeffff 889435fcfeffff 0fb68c1dfcfeffff 0fb6c2 03c8 8b450c 0fb6c9 }
            // n = 7, score = 200
            //   88841dfcfeffff       | mov                 byte ptr [ebp + ebx - 0x104], al
            //   889435fcfeffff       | mov                 byte ptr [ebp + esi - 0x104], dl
            //   0fb68c1dfcfeffff     | movzx               ecx, byte ptr [ebp + ebx - 0x104]
            //   0fb6c2               | movzx               eax, dl
            //   03c8                 | add                 ecx, eax
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   0fb6c9               | movzx               ecx, cl

        $sequence_8 = { 59 837e04ff 8bd8 8d7e08 7504 8b2f }
            // n = 6, score = 100
            //   59                   | pop                 ecx
            //   837e04ff             | cmp                 dword ptr [esi + 4], -1
            //   8bd8                 | mov                 ebx, eax
            //   8d7e08               | lea                 edi, [esi + 8]
            //   7504                 | jne                 6
            //   8b2f                 | mov                 ebp, dword ptr [edi]

        $sequence_9 = { 53 6a00 6a00 ff15???????? 833e05 7521 }
            // n = 6, score = 100
            //   53                   | push                ebx
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   833e05               | cmp                 dword ptr [esi], 5
            //   7521                 | jne                 0x23

        $sequence_10 = { 8d7e08 7504 8b2f eb02 8bef 8b06 83661c00 }
            // n = 7, score = 100
            //   8d7e08               | lea                 edi, [esi + 8]
            //   7504                 | jne                 6
            //   8b2f                 | mov                 ebp, dword ptr [edi]
            //   eb02                 | jmp                 4
            //   8bef                 | mov                 ebp, edi
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   83661c00             | and                 dword ptr [esi + 0x1c], 0

        $sequence_11 = { eb60 8b46f8 834de4ff 49 c745e8ff000000 8b3c857c300010 }
            // n = 6, score = 100
            //   eb60                 | jmp                 0x62
            //   8b46f8               | mov                 eax, dword ptr [esi - 8]
            //   834de4ff             | or                  dword ptr [ebp - 0x1c], 0xffffffff
            //   49                   | dec                 ecx
            //   c745e8ff000000       | mov                 dword ptr [ebp - 0x18], 0xff
            //   8b3c857c300010       | mov                 edi, dword ptr [eax*4 + 0x1000307c]

        $sequence_12 = { 49 c745e8ff000000 8b3c857c300010 c745ecffff0000 0faff9 83f801 c745f0ffffff00 }
            // n = 7, score = 100
            //   49                   | dec                 ecx
            //   c745e8ff000000       | mov                 dword ptr [ebp - 0x18], 0xff
            //   8b3c857c300010       | mov                 edi, dword ptr [eax*4 + 0x1000307c]
            //   c745ecffff0000       | mov                 dword ptr [ebp - 0x14], 0xffff
            //   0faff9               | imul                edi, ecx
            //   83f801               | cmp                 eax, 1
            //   c745f0ffffff00       | mov                 dword ptr [ebp - 0x10], 0xffffff

        $sequence_13 = { 894dfc eb0e 8b14957c300010 49 0fafd1 }
            // n = 5, score = 100
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx
            //   eb0e                 | jmp                 0x10
            //   8b14957c300010       | mov                 edx, dword ptr [edx*4 + 0x1000307c]
            //   49                   | dec                 ecx
            //   0fafd1               | imul                edx, ecx

        $sequence_14 = { 83f807 0f87c7000000 ff24857e230010 832700 e9???????? }
            // n = 5, score = 100
            //   83f807               | cmp                 eax, 7
            //   0f87c7000000         | ja                  0xcd
            //   ff24857e230010       | jmp                 dword ptr [eax*4 + 0x1000237e]
            //   832700               | and                 dword ptr [edi], 0
            //   e9????????           |                     

        $sequence_15 = { e9???????? 33c0 8b7df4 8b0c855c300010 }
            // n = 4, score = 100
            //   e9????????           |                     
            //   33c0                 | xor                 eax, eax
            //   8b7df4               | mov                 edi, dword ptr [ebp - 0xc]
            //   8b0c855c300010       | mov                 ecx, dword ptr [eax*4 + 0x1000305c]

    condition:
        7 of them and filesize < 57344
}