rule win_quan_pin_loader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.quan_pin_loader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.quan_pin_loader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b4d08 e8???????? 85c0 750f 0fb703 6683f80d 7406 }
            // n = 7, score = 100
            //   8b4d08               | dec                 eax
            //   e8????????           |                     
            //   85c0                 | mov                 ebx, ecx
            //   750f                 | dec                 eax
            //   0fb703               | lea                 edi, [0xfff8fddc]
            //   6683f80d             | dec                 eax
            //   7406                 | mov                 ecx, edi

        $sequence_1 = { 83630800 488d0524c10400 488903 eb3a 41b804000000 488d15d6ba0400 e8???????? }
            // n = 7, score = 100
            //   83630800             | shr                 eax, 0x18
            //   488d0524c10400       | inc                 edi
            //   488903               | mov                 ecx, dword ptr [ebp + eax*4 + 0x94c20]
            //   eb3a                 | inc                 ebp
            //   41b804000000         | mov                 eax, ebx
            //   488d15d6ba0400       | inc                 ebp
            //   e8????????           |                     

        $sequence_2 = { 4183f904 7410 4183f906 0f85c8fdffff 0fbaea0a eb0a 0fbaea08 }
            // n = 7, score = 100
            //   4183f904             | je                  0x401
            //   7410                 | mov                 eax, dword ptr [esp + 0x20]
            //   4183f906             | mov                 dword ptr [edi], eax
            //   0f85c8fdffff         | mov                 eax, dword ptr [esp + 0x24]
            //   0fbaea0a             | sub                 eax, dword ptr [esp + 0x34]
            //   eb0a                 | add                 eax, dword ptr [esp + 0x3c]
            //   0fbaea08             | je                  0x416

        $sequence_3 = { 84d2 7418 c6415401 d1e8 eb14 488d1524a80300 b806000000 }
            // n = 7, score = 100
            //   84d2                 | mov                 eax, dword ptr [edx + 8]
            //   7418                 | jne                 0x1f6
            //   c6415401             | dec                 eax
            //   d1e8                 | mov                 eax, ecx
            //   eb14                 | jne                 0x208
            //   488d1524a80300       | dec                 ecx
            //   b806000000           | mov                 dword ptr [eax], ecx

        $sequence_4 = { 4d8bc6 418bd7 488bcf e8???????? 8bf0 85c0 0f8850010000 }
            // n = 7, score = 100
            //   4d8bc6               | dec                 eax
            //   418bd7               | lea                 ecx, [esp + 0x30]
            //   488bcf               | dec                 eax
            //   e8????????           |                     
            //   8bf0                 | mov                 ebx, dword ptr [esp + 0x60]
            //   85c0                 | dec                 eax
            //   0f8850010000         | mov                 ebp, dword ptr [esp + 0x68]

        $sequence_5 = { 488b5d60 488d4c2430 e8???????? 488d4c2420 e8???????? 4883eb20 }
            // n = 6, score = 100
            //   488b5d60             | inc                 ecx
            //   488d4c2430           | mov                 eax, ecx
            //   e8????????           |                     
            //   488d4c2420           | inc                 ecx
            //   e8????????           |                     
            //   4883eb20             | xor                 esi, dword ptr [esp + ecx*4 + 0x73cf0]

        $sequence_6 = { b904010000 660b0d???????? 66890d???????? 480fbae71e 7224 0fb7c5 ba0f000000 }
            // n = 7, score = 100
            //   b904010000           | cmp                 ebx, edi
            //   660b0d????????       |                     
            //   66890d????????       |                     
            //   480fbae71e           | je                  0x1b1
            //   7224                 | nop                 dword ptr [eax]
            //   0fb7c5               | dec                 eax
            //   ba0f000000           | mov                 ecx, ebx

        $sequence_7 = { 488b5008 488b4810 482bca 48c1f902 493bcd }
            // n = 5, score = 100
            //   488b5008             | mov                 ecx, dword ptr [eax]
            //   488b4810             | inc                 esp
            //   482bca               | cmp                 ecx, edx
            //   48c1f902             | jg                  0x779
            //   493bcd               | inc                 ecx

        $sequence_8 = { 488bcb 0f2845e0 660f7f45e0 e8???????? e9???????? c745e805000000 488d0539ef0400 }
            // n = 7, score = 100
            //   488bcb               | lea                 ecx, [esp + 0x60]
            //   0f2845e0             | dec                 eax
            //   660f7f45e0           | mov                 ecx, dword ptr [eax]
            //   e8????????           |                     
            //   e9????????           |                     
            //   c745e805000000       | mov                 ebx, dword ptr [eax + 8]
            //   488d0539ef0400       | jmp                 0x13e8

        $sequence_9 = { 41b907000000 4c8bc3 8bd5 ff5018 8bf8 8b442478 }
            // n = 6, score = 100
            //   41b907000000         | je                  0x3f3
            //   4c8bc3               | mov                 edx, 1
            //   8bd5                 | dec                 eax
            //   ff5018               | mov                 eax, dword ptr [ecx]
            //   8bf8                 | call                dword ptr [eax + 0x20]
            //   8b442478             | test                eax, eax

    condition:
        7 of them and filesize < 1711104
}