rule win_quantloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.quantloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.quantloader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8945f8 837df800 7405 8b45f8 ffd0 c9 c3 }
            // n = 7, score = 500
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   837df800             | cmp                 dword ptr [ebp - 8], 0
            //   7405                 | je                  7
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   ffd0                 | call                eax
            //   c9                   | leave               
            //   c3                   | ret                 

        $sequence_1 = { e8???????? c744240800000000 c7442404???????? 8b4508 890424 e8???????? 85c0 }
            // n = 7, score = 500
            //   e8????????           |                     
            //   c744240800000000     | mov                 dword ptr [esp + 8], 0
            //   c7442404????????     |                     
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   85c0                 | test                eax, eax

        $sequence_2 = { 8b45f8 40 8945f0 eb13 }
            // n = 4, score = 500
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   40                   | inc                 eax
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   eb13                 | jmp                 0x15

        $sequence_3 = { c785d4f7ffff00000000 e9???????? c744241400000000 c744241000000084 c744240c00000000 c744240800000000 8b4508 }
            // n = 7, score = 500
            //   c785d4f7ffff00000000     | mov    dword ptr [ebp - 0x82c], 0
            //   e9????????           |                     
            //   c744241400000000     | mov                 dword ptr [esp + 0x14], 0
            //   c744241000000084     | mov                 dword ptr [esp + 0x10], 0x84000000
            //   c744240c00000000     | mov                 dword ptr [esp + 0xc], 0
            //   c744240800000000     | mov                 dword ptr [esp + 8], 0
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

        $sequence_4 = { c70424???????? e8???????? 83ec08 8b450c }
            // n = 4, score = 500
            //   c70424????????       |                     
            //   e8????????           |                     
            //   83ec08               | sub                 esp, 8
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]

        $sequence_5 = { 837df400 750f c785d4f7ffff00000000 e9???????? }
            // n = 4, score = 500
            //   837df400             | cmp                 dword ptr [ebp - 0xc], 0
            //   750f                 | jne                 0x11
            //   c785d4f7ffff00000000     | mov    dword ptr [ebp - 0x82c], 0
            //   e9????????           |                     

        $sequence_6 = { c70424???????? e8???????? 85c0 0f8eaa000000 }
            // n = 4, score = 500
            //   c70424????????       |                     
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f8eaa000000         | jle                 0xb0

        $sequence_7 = { e8???????? 89442404 c70424???????? e8???????? c7442408???????? c7442404???????? c7042402000080 }
            // n = 7, score = 500
            //   e8????????           |                     
            //   89442404             | mov                 dword ptr [esp + 4], eax
            //   c70424????????       |                     
            //   e8????????           |                     
            //   c7442408????????     |                     
            //   c7442404????????     |                     
            //   c7042402000080       | mov                 dword ptr [esp], 0x80000002

        $sequence_8 = { 33c0 66ad 66a90030 7408 }
            // n = 4, score = 100
            //   33c0                 | xor                 eax, eax
            //   66ad                 | lodsw               ax, word ptr [esi]
            //   66a90030             | test                ax, 0x3000
            //   7408                 | je                  0xa

        $sequence_9 = { c3 8b7d74 6a04 6800100000 57 6a00 ff5510 }
            // n = 7, score = 100
            //   c3                   | ret                 
            //   8b7d74               | mov                 edi, dword ptr [ebp + 0x74]
            //   6a04                 | push                4
            //   6800100000           | push                0x1000
            //   57                   | push                edi
            //   6a00                 | push                0
            //   ff5510               | call                dword ptr [ebp + 0x10]

        $sequence_10 = { 60 8bf3 03763c 8bb680000000 85f6 }
            // n = 5, score = 100
            //   60                   | pushal              
            //   8bf3                 | mov                 esi, ebx
            //   03763c               | add                 esi, dword ptr [esi + 0x3c]
            //   8bb680000000         | mov                 esi, dword ptr [esi + 0x80]
            //   85f6                 | test                esi, esi

        $sequence_11 = { c7457c00000000 81c243e15762 8b4d74 8bfe 837d6400 7403 017564 }
            // n = 7, score = 100
            //   c7457c00000000       | mov                 dword ptr [ebp + 0x7c], 0
            //   81c243e15762         | add                 edx, 0x6257e143
            //   8b4d74               | mov                 ecx, dword ptr [ebp + 0x74]
            //   8bfe                 | mov                 edi, esi
            //   837d6400             | cmp                 dword ptr [ebp + 0x64], 0
            //   7403                 | je                  5
            //   017564               | add                 dword ptr [ebp + 0x64], esi

        $sequence_12 = { 7410 b904000000 48 7408 b940000000 48 7400 }
            // n = 7, score = 100
            //   7410                 | je                  0x12
            //   b904000000           | mov                 ecx, 4
            //   48                   | dec                 eax
            //   7408                 | je                  0xa
            //   b940000000           | mov                 ecx, 0x40
            //   48                   | dec                 eax
            //   7400                 | je                  2

        $sequence_13 = { 8bf8 f3a4 e8???????? 48 }
            // n = 4, score = 100
            //   8bf8                 | mov                 edi, eax
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   e8????????           |                     
            //   48                   | dec                 eax

        $sequence_14 = { 51 50 54 6a04 51 57 ff550c }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   50                   | push                eax
            //   54                   | push                esp
            //   6a04                 | push                4
            //   51                   | push                ecx
            //   57                   | push                edi
            //   ff550c               | call                dword ptr [ebp + 0xc]

        $sequence_15 = { 33c0 39411c 74f7 ff711c 8f4550 e8???????? 8f411c }
            // n = 7, score = 100
            //   33c0                 | xor                 eax, eax
            //   39411c               | cmp                 dword ptr [ecx + 0x1c], eax
            //   74f7                 | je                  0xfffffff9
            //   ff711c               | push                dword ptr [ecx + 0x1c]
            //   8f4550               | pop                 dword ptr [ebp + 0x50]
            //   e8????????           |                     
            //   8f411c               | pop                 dword ptr [ecx + 0x1c]

    condition:
        7 of them and filesize < 155648
}