rule win_quickheal_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.quickheal."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.quickheal"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33c0 8d7c2431 c78424ec0300001c010000 f3ab 66ab }
            // n = 5, score = 100
            //   33c0                 | xor                 eax, eax
            //   8d7c2431             | lea                 edi, [esp + 0x31]
            //   c78424ec0300001c010000     | mov    dword ptr [esp + 0x3ec], 0x11c
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   66ab                 | stosw               word ptr es:[edi], ax

        $sequence_1 = { 66898c2494040000 b940000000 f3ab c784249800000003000000 c78424cc000000058288a2 }
            // n = 5, score = 100
            //   66898c2494040000     | mov                 word ptr [esp + 0x494], cx
            //   b940000000           | mov                 ecx, 0x40
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   c784249800000003000000     | mov    dword ptr [esp + 0x98], 3
            //   c78424cc000000058288a2     | mov    dword ptr [esp + 0xcc], 0xa2888205

        $sequence_2 = { 8b542414 6a07 52 895c2478 895c247c }
            // n = 5, score = 100
            //   8b542414             | mov                 edx, dword ptr [esp + 0x14]
            //   6a07                 | push                7
            //   52                   | push                edx
            //   895c2478             | mov                 dword ptr [esp + 0x78], ebx
            //   895c247c             | mov                 dword ptr [esp + 0x7c], ebx

        $sequence_3 = { 8944242c 55 e9???????? ffd6 68???????? 57 8944243c }
            // n = 7, score = 100
            //   8944242c             | mov                 dword ptr [esp + 0x2c], eax
            //   55                   | push                ebp
            //   e9????????           |                     
            //   ffd6                 | call                esi
            //   68????????           |                     
            //   57                   | push                edi
            //   8944243c             | mov                 dword ptr [esp + 0x3c], eax

        $sequence_4 = { 89542450 f7d1 89542454 49 8bf9 8d043f 50 }
            // n = 7, score = 100
            //   89542450             | mov                 dword ptr [esp + 0x50], edx
            //   f7d1                 | not                 ecx
            //   89542454             | mov                 dword ptr [esp + 0x54], edx
            //   49                   | dec                 ecx
            //   8bf9                 | mov                 edi, ecx
            //   8d043f               | lea                 eax, [edi + edi]
            //   50                   | push                eax

        $sequence_5 = { 7527 85ed 7523 8b4c2414 e8???????? 53 892d???????? }
            // n = 7, score = 100
            //   7527                 | jne                 0x29
            //   85ed                 | test                ebp, ebp
            //   7523                 | jne                 0x25
            //   8b4c2414             | mov                 ecx, dword ptr [esp + 0x14]
            //   e8????????           |                     
            //   53                   | push                ebx
            //   892d????????         |                     

        $sequence_6 = { 8d5c2410 83c404 8944240c c1eb04 8d740704 e8???????? 3206 }
            // n = 7, score = 100
            //   8d5c2410             | lea                 ebx, [esp + 0x10]
            //   83c404               | add                 esp, 4
            //   8944240c             | mov                 dword ptr [esp + 0xc], eax
            //   c1eb04               | shr                 ebx, 4
            //   8d740704             | lea                 esi, [edi + eax + 4]
            //   e8????????           |                     
            //   3206                 | xor                 al, byte ptr [esi]

        $sequence_7 = { ffd7 3bc3 0f845d040000 8d8c24d8150000 2bc6 }
            // n = 5, score = 100
            //   ffd7                 | call                edi
            //   3bc3                 | cmp                 eax, ebx
            //   0f845d040000         | je                  0x463
            //   8d8c24d8150000       | lea                 ecx, [esp + 0x15d8]
            //   2bc6                 | sub                 eax, esi

        $sequence_8 = { 23e9 f7d2 23d6 0bd5 8b6c243c 03d5 03da }
            // n = 7, score = 100
            //   23e9                 | and                 ebp, ecx
            //   f7d2                 | not                 edx
            //   23d6                 | and                 edx, esi
            //   0bd5                 | or                  edx, ebp
            //   8b6c243c             | mov                 ebp, dword ptr [esp + 0x3c]
            //   03d5                 | add                 edx, ebp
            //   03da                 | add                 ebx, edx

        $sequence_9 = { 8b542420 c1f802 8d0440 3bd0 0f8c8e030000 8d46fc 53 }
            // n = 7, score = 100
            //   8b542420             | mov                 edx, dword ptr [esp + 0x20]
            //   c1f802               | sar                 eax, 2
            //   8d0440               | lea                 eax, [eax + eax*2]
            //   3bd0                 | cmp                 edx, eax
            //   0f8c8e030000         | jl                  0x394
            //   8d46fc               | lea                 eax, [esi - 4]
            //   53                   | push                ebx

    condition:
        7 of them and filesize < 553984
}