rule win_quickmute_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.quickmute."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.quickmute"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c78550ffffff7265616c c78554ffffff6c6f6300 391d???????? 750f 8d8550ffffff 50 }
            // n = 6, score = 100
            //   c78550ffffff7265616c     | mov    dword ptr [ebp - 0xb0], 0x6c616572
            //   c78554ffffff6c6f6300     | mov    dword ptr [ebp - 0xac], 0x636f6c
            //   391d????????         |                     
            //   750f                 | jne                 0x11
            //   8d8550ffffff         | lea                 eax, [ebp - 0xb0]
            //   50                   | push                eax

        $sequence_1 = { 6a00 52 ff15???????? 83c40c 6a10 8d45ec 6a00 }
            // n = 7, score = 100
            //   6a00                 | push                0
            //   52                   | push                edx
            //   ff15????????         |                     
            //   83c40c               | add                 esp, 0xc
            //   6a10                 | push                0x10
            //   8d45ec               | lea                 eax, [ebp - 0x14]
            //   6a00                 | push                0

        $sequence_2 = { 8b75fc 85f6 740c 56 }
            // n = 4, score = 100
            //   8b75fc               | mov                 esi, dword ptr [ebp - 4]
            //   85f6                 | test                esi, esi
            //   740c                 | je                  0xe
            //   56                   | push                esi

        $sequence_3 = { 0f8410020000 837dec00 755e 837df000 7558 837df400 }
            // n = 6, score = 100
            //   0f8410020000         | je                  0x216
            //   837dec00             | cmp                 dword ptr [ebp - 0x14], 0
            //   755e                 | jne                 0x60
            //   837df000             | cmp                 dword ptr [ebp - 0x10], 0
            //   7558                 | jne                 0x5a
            //   837df400             | cmp                 dword ptr [ebp - 0xc], 0

        $sequence_4 = { ffd7 a3???????? 833d????????00 c68560ffffff47 889d61ffffff c78562ffffff74537461 c78566ffffff72747570 }
            // n = 7, score = 100
            //   ffd7                 | call                edi
            //   a3????????           |                     
            //   833d????????00       |                     
            //   c68560ffffff47       | mov                 byte ptr [ebp - 0xa0], 0x47
            //   889d61ffffff         | mov                 byte ptr [ebp - 0x9f], bl
            //   c78562ffffff74537461     | mov    dword ptr [ebp - 0x9e], 0x61745374
            //   c78566ffffff72747570     | mov    dword ptr [ebp - 0x9a], 0x70757472

        $sequence_5 = { 8b7508 c7465ca89b4000 83660800 33ff 47 897e14 }
            // n = 6, score = 100
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   c7465ca89b4000       | mov                 dword ptr [esi + 0x5c], 0x409ba8
            //   83660800             | and                 dword ptr [esi + 8], 0
            //   33ff                 | xor                 edi, edi
            //   47                   | inc                 edi
            //   897e14               | mov                 dword ptr [esi + 0x14], edi

        $sequence_6 = { 8d45b4 50 56 ffd7 a3???????? 833d????????00 }
            // n = 6, score = 100
            //   8d45b4               | lea                 eax, [ebp - 0x4c]
            //   50                   | push                eax
            //   56                   | push                esi
            //   ffd7                 | call                edi
            //   a3????????           |                     
            //   833d????????00       |                     

        $sequence_7 = { 8d7c2410 e8???????? 803d????????00 756b }
            // n = 4, score = 100
            //   8d7c2410             | lea                 edi, [esp + 0x10]
            //   e8????????           |                     
            //   803d????????00       |                     
            //   756b                 | jne                 0x6d

        $sequence_8 = { 66c7855affffff656e 889d5cffffff c7855dffffff69616c73 c68561ffffff00 750f 8d954cffffff 52 }
            // n = 7, score = 100
            //   66c7855affffff656e     | mov    word ptr [ebp - 0xa6], 0x6e65
            //   889d5cffffff         | mov                 byte ptr [ebp - 0xa4], bl
            //   c7855dffffff69616c73     | mov    dword ptr [ebp - 0xa3], 0x736c6169
            //   c68561ffffff00       | mov                 byte ptr [ebp - 0x9f], 0
            //   750f                 | jne                 0x11
            //   8d954cffffff         | lea                 edx, [ebp - 0xb4]
            //   52                   | push                edx

        $sequence_9 = { 6a0d 58 5d c3 8b04cd74c14000 5d c3 }
            // n = 7, score = 100
            //   6a0d                 | push                0xd
            //   58                   | pop                 eax
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   8b04cd74c14000       | mov                 eax, dword ptr [ecx*8 + 0x40c174]
            //   5d                   | pop                 ebp
            //   c3                   | ret                 

    condition:
        7 of them and filesize < 146432
}