rule win_quirkyloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.quirkyloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.quirkyloader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 488bd8 488d15636d1200 488d4b10 41b880000000 e8???????? 488d4e10 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488bd8               | mov                 dword ptr [ebp - 0x4c], ecx
            //   488d15636d1200       | mov                 edx, ebx
            //   488d4b10             | mov                 dword ptr [ebp - 0x44], edx
            //   41b880000000         | dec                 eax
            //   e8????????           |                     
            //   488d4e10             | lea                 ecx, [ebp - 0x78]

        $sequence_1 = { e8???????? 85c0 740e b801000000 4883c438 5b 5e }
            // n = 7, score = 100
            //   e8????????           |                     
            //   85c0                 | dec                 esp
            //   740e                 | mov                 esi, eax
            //   b801000000           | mov                 dword ptr [ebx + 8], ebp
            //   4883c438             | dec                 eax
            //   5b                   | lea                 ecx, [0x8fa7c]
            //   5e                   | dec                 eax

        $sequence_2 = { 4c8d8c2488000000 488bcb 4533c0 e8???????? 4c8bf8 4c8b6b40 4d85ff }
            // n = 7, score = 100
            //   4c8d8c2488000000     | mov                 ecx, dword ptr [esp + 0x60]
            //   488bcb               | dec                 esp
            //   4533c0               | lea                 eax, [0x2132e7]
            //   e8????????           |                     
            //   4c8bf8               | dec                 esp
            //   4c8b6b40             | lea                 eax, [esp + 0x68]
            //   4d85ff               | dec                 eax

        $sequence_3 = { e8???????? 498bcd e8???????? 488d0d0a1a0300 e8???????? 488bd8 e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   498bcd               | test                eax, eax
            //   e8????????           |                     
            //   488d0d0a1a0300       | je                  0x15cf
            //   e8????????           |                     
            //   488bd8               | dec                 eax
            //   e8????????           |                     

        $sequence_4 = { 8b7a04 49033f 4803f9 4803fb 483bdf 731f 488b0b }
            // n = 7, score = 100
            //   8b7a04               | inc                 esp
            //   49033f               | mov                 eax, dword ptr [ebp - 0x54]
            //   4803f9               | dec                 eax
            //   4803fb               | mov                 ebx, eax
            //   483bdf               | dec                 eax
            //   731f                 | lea                 ecx, [ebp - 0x80]
            //   488b0b               | mov                 edx, dword ptr [ebp - 0x50]

        $sequence_5 = { ffc8 488d1480 498b4230 488d0cd0 488b4110 49894110 49c741f801000000 }
            // n = 7, score = 100
            //   ffc8                 | cmp                 dword ptr [ecx], ecx
            //   488d1480             | dec                 esp
            //   498b4230             | mov                 esp, eax
            //   488d0cd0             | dec                 ebp
            //   488b4110             | test                esp, esp
            //   49894110             | jne                 0xcd6
            //   49c741f801000000     | xor                 ecx, ecx

        $sequence_6 = { 80b9b901000000 7502 eb15 488bce e8???????? 488bc8 33d2 }
            // n = 7, score = 100
            //   80b9b901000000       | je                  0xbf2
            //   7502                 | inc                 esp
            //   eb15                 | mov                 esi, dword ptr [ebp + 8]
            //   488bce               | inc                 esp
            //   e8????????           |                     
            //   488bc8               | cmp                 esi, esi
            //   33d2                 | jbe                 0xc3d

        $sequence_7 = { eb02 8bc6 8945cc 488b4518 488b4818 48898d70ffffff 488b4518 }
            // n = 7, score = 100
            //   eb02                 | mov                 edx, ebp
            //   8bc6                 | dec                 eax
            //   8945cc               | mov                 ebp, dword ptr [ebx + 0x10]
            //   488b4518             | dec                 eax
            //   488b4818             | mov                 edi, dword ptr [ebx + 0x20]
            //   48898d70ffffff       | dec                 eax
            //   488b4518             | lea                 ecx, [0x5e632]

        $sequence_8 = { f7da 41b9ff000000 83e207 0fb6ca 488d95c0000000 62d17e486f00 62f17e487f4502 }
            // n = 7, score = 100
            //   f7da                 | dec                 ecx
            //   41b9ff000000         | cmp                 dword ptr [ebp - 8], 0
            //   83e207               | jne                 0x25f
            //   0fb6ca               | inc                 ecx
            //   488d95c0000000       | cmp                 byte ptr [ebp], 0
            //   62d17e486f00         | jne                 0x1b4
            //   62f17e487f4502       | test                ebp, 0x800000

        $sequence_9 = { e8???????? 488bc3 8138ffffff7f 7409 488bc3 8b00 ffc0 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488bc3               | mov                 ecx, dword ptr [ebp - 0x10]
            //   8138ffffff7f         | dec                 esp
            //   7409                 | lea                 edx, [0xc2443]
            //   488bc3               | inc                 ecx
            //   8b00                 | call                dword ptr [edx]
            //   ffc0                 | test                eax, eax

    condition:
        7 of them and filesize < 4722688
}