rule win_quiterat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.quiterat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.quiterat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d442440 50 8d442418 50 8d442438 50 8d4c241c }
            // n = 7, score = 100
            //   8d442440             | lea                 eax, [esp + 0x40]
            //   50                   | push                eax
            //   8d442418             | lea                 eax, [esp + 0x18]
            //   50                   | push                eax
            //   8d442438             | lea                 eax, [esp + 0x38]
            //   50                   | push                eax
            //   8d4c241c             | lea                 ecx, [esp + 0x1c]

        $sequence_1 = { 8d4dac e8???????? 8d4db0 c645fc2b e8???????? 8d45ec 50 }
            // n = 7, score = 100
            //   8d4dac               | lea                 ecx, [ebp - 0x54]
            //   e8????????           |                     
            //   8d4db0               | lea                 ecx, [ebp - 0x50]
            //   c645fc2b             | mov                 byte ptr [ebp - 4], 0x2b
            //   e8????????           |                     
            //   8d45ec               | lea                 eax, [ebp - 0x14]
            //   50                   | push                eax

        $sequence_2 = { e8???????? 8d4c2410 51 50 8bcf e8???????? 8d4c2410 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8d4c2410             | lea                 ecx, [esp + 0x10]
            //   51                   | push                ecx
            //   50                   | push                eax
            //   8bcf                 | mov                 ecx, edi
            //   e8????????           |                     
            //   8d4c2410             | lea                 ecx, [esp + 0x10]

        $sequence_3 = { 8d442424 57 50 e8???????? 8b8424bc020000 83c40c 8bc8 }
            // n = 7, score = 100
            //   8d442424             | lea                 eax, [esp + 0x24]
            //   57                   | push                edi
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b8424bc020000       | mov                 eax, dword ptr [esp + 0x2bc]
            //   83c40c               | add                 esp, 0xc
            //   8bc8                 | mov                 ecx, eax

        $sequence_4 = { e8???????? 6a01 68???????? 8d4c2430 e8???????? ff7004 ff30 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   6a01                 | push                1
            //   68????????           |                     
            //   8d4c2430             | lea                 ecx, [esp + 0x30]
            //   e8????????           |                     
            //   ff7004               | push                dword ptr [eax + 4]
            //   ff30                 | push                dword ptr [eax]

        $sequence_5 = { f00fc108 0f95c0 84c0 756e 8b44241c eb5b 837f1006 }
            // n = 7, score = 100
            //   f00fc108             | lock xadd           dword ptr [eax], ecx
            //   0f95c0               | setne               al
            //   84c0                 | test                al, al
            //   756e                 | jne                 0x70
            //   8b44241c             | mov                 eax, dword ptr [esp + 0x1c]
            //   eb5b                 | jmp                 0x5d
            //   837f1006             | cmp                 dword ptr [edi + 0x10], 6

        $sequence_6 = { 8b7c241c 8a4c2440 8b4360 8b5364 3b4368 7505 3b536c }
            // n = 7, score = 100
            //   8b7c241c             | mov                 edi, dword ptr [esp + 0x1c]
            //   8a4c2440             | mov                 cl, byte ptr [esp + 0x40]
            //   8b4360               | mov                 eax, dword ptr [ebx + 0x60]
            //   8b5364               | mov                 edx, dword ptr [ebx + 0x64]
            //   3b4368               | cmp                 eax, dword ptr [ebx + 0x68]
            //   7505                 | jne                 7
            //   3b536c               | cmp                 edx, dword ptr [ebx + 0x6c]

        $sequence_7 = { 8b7c242c 8b4108 83c004 8d1481 89542418 8b410c 8d0c81 }
            // n = 7, score = 100
            //   8b7c242c             | mov                 edi, dword ptr [esp + 0x2c]
            //   8b4108               | mov                 eax, dword ptr [ecx + 8]
            //   83c004               | add                 eax, 4
            //   8d1481               | lea                 edx, [ecx + eax*4]
            //   89542418             | mov                 dword ptr [esp + 0x18], edx
            //   8b410c               | mov                 eax, dword ptr [ecx + 0xc]
            //   8d0c81               | lea                 ecx, [ecx + eax*4]

        $sequence_8 = { c20800 6aff 6a00 68???????? 8d442440 b9???????? 50 }
            // n = 7, score = 100
            //   c20800               | ret                 8
            //   6aff                 | push                -1
            //   6a00                 | push                0
            //   68????????           |                     
            //   8d442440             | lea                 eax, [esp + 0x40]
            //   b9????????           |                     
            //   50                   | push                eax

        $sequence_9 = { 8bf1 33db 57 c706???????? 395e50 7e2d 33ff }
            // n = 7, score = 100
            //   8bf1                 | mov                 esi, ecx
            //   33db                 | xor                 ebx, ebx
            //   57                   | push                edi
            //   c706????????         |                     
            //   395e50               | cmp                 dword ptr [esi + 0x50], ebx
            //   7e2d                 | jle                 0x2f
            //   33ff                 | xor                 edi, edi

    condition:
        7 of them and filesize < 5892096
}