rule win_r980_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.r980."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.r980"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c40c e9???????? a900040000 0f84b0000000 837f1408 7204 8b07 }
            // n = 7, score = 200
            //   83c40c               | add                 esp, 0xc
            //   e9????????           |                     
            //   a900040000           | test                eax, 0x400
            //   0f84b0000000         | je                  0xb6
            //   837f1408             | cmp                 dword ptr [edi + 0x14], 8
            //   7204                 | jb                  6
            //   8b07                 | mov                 eax, dword ptr [edi]

        $sequence_1 = { 8bc8 e8???????? 8d45d8 50 8d8d38ffffff e8???????? ff7524 }
            // n = 7, score = 200
            //   8bc8                 | mov                 ecx, eax
            //   e8????????           |                     
            //   8d45d8               | lea                 eax, [ebp - 0x28]
            //   50                   | push                eax
            //   8d8d38ffffff         | lea                 ecx, [ebp - 0xc8]
            //   e8????????           |                     
            //   ff7524               | push                dword ptr [ebp + 0x24]

        $sequence_2 = { e8???????? 8b75e0 83c414 83fe03 7707 ff24b5c8ba4000 e8???????? }
            // n = 7, score = 200
            //   e8????????           |                     
            //   8b75e0               | mov                 esi, dword ptr [ebp - 0x20]
            //   83c414               | add                 esp, 0x14
            //   83fe03               | cmp                 esi, 3
            //   7707                 | ja                  9
            //   ff24b5c8ba4000       | jmp                 dword ptr [esi*4 + 0x40bac8]
            //   e8????????           |                     

        $sequence_3 = { ff5004 c745fc07000000 8b7510 85f6 741e 8bc3 f00fc14604 }
            // n = 7, score = 200
            //   ff5004               | call                dword ptr [eax + 4]
            //   c745fc07000000       | mov                 dword ptr [ebp - 4], 7
            //   8b7510               | mov                 esi, dword ptr [ebp + 0x10]
            //   85f6                 | test                esi, esi
            //   741e                 | je                  0x20
            //   8bc3                 | mov                 eax, ebx
            //   f00fc14604           | lock xadd           dword ptr [esi + 4], eax

        $sequence_4 = { 68???????? e8???????? 51 6a20 50 8d8df0f9ffff c645fc04 }
            // n = 7, score = 200
            //   68????????           |                     
            //   e8????????           |                     
            //   51                   | push                ecx
            //   6a20                 | push                0x20
            //   50                   | push                eax
            //   8d8df0f9ffff         | lea                 ecx, [ebp - 0x610]
            //   c645fc04             | mov                 byte ptr [ebp - 4], 4

        $sequence_5 = { 33c1 8944960c 8b44241c 8b8810010000 8b8014010000 8d0c88 8d4204 }
            // n = 7, score = 200
            //   33c1                 | xor                 eax, ecx
            //   8944960c             | mov                 dword ptr [esi + edx*4 + 0xc], eax
            //   8b44241c             | mov                 eax, dword ptr [esp + 0x1c]
            //   8b8810010000         | mov                 ecx, dword ptr [eax + 0x110]
            //   8b8014010000         | mov                 eax, dword ptr [eax + 0x114]
            //   8d0c88               | lea                 ecx, [eax + ecx*4]
            //   8d4204               | lea                 eax, [edx + 4]

        $sequence_6 = { c60100 e8???????? e8???????? 8d942490000000 b9???????? e8???????? 8d842490000000 }
            // n = 7, score = 200
            //   c60100               | mov                 byte ptr [ecx], 0
            //   e8????????           |                     
            //   e8????????           |                     
            //   8d942490000000       | lea                 edx, [esp + 0x90]
            //   b9????????           |                     
            //   e8????????           |                     
            //   8d842490000000       | lea                 eax, [esp + 0x90]

        $sequence_7 = { 722c 8b4640 8945a4 8d0c38 894e40 8b4630 8945ac }
            // n = 7, score = 200
            //   722c                 | jb                  0x2e
            //   8b4640               | mov                 eax, dword ptr [esi + 0x40]
            //   8945a4               | mov                 dword ptr [ebp - 0x5c], eax
            //   8d0c38               | lea                 ecx, [eax + edi]
            //   894e40               | mov                 dword ptr [esi + 0x40], ecx
            //   8b4630               | mov                 eax, dword ptr [esi + 0x30]
            //   8945ac               | mov                 dword ptr [ebp - 0x54], eax

        $sequence_8 = { 8bcf e8???????? 8a00 8806 834710ff 7509 c7470c00000000 }
            // n = 7, score = 200
            //   8bcf                 | mov                 ecx, edi
            //   e8????????           |                     
            //   8a00                 | mov                 al, byte ptr [eax]
            //   8806                 | mov                 byte ptr [esi], al
            //   834710ff             | add                 dword ptr [edi + 0x10], -1
            //   7509                 | jne                 0xb
            //   c7470c00000000       | mov                 dword ptr [edi + 0xc], 0

        $sequence_9 = { 68???????? 8d45b4 c745ac0f000000 50 c745a800000000 c6459800 e8???????? }
            // n = 7, score = 200
            //   68????????           |                     
            //   8d45b4               | lea                 eax, [ebp - 0x4c]
            //   c745ac0f000000       | mov                 dword ptr [ebp - 0x54], 0xf
            //   50                   | push                eax
            //   c745a800000000       | mov                 dword ptr [ebp - 0x58], 0
            //   c6459800             | mov                 byte ptr [ebp - 0x68], 0
            //   e8????????           |                     

    condition:
        7 of them and filesize < 3178496
}