rule win_raccoon_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.raccoon."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.raccoon"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 53 ff75f8 c745fcff070000 ff15???????? 85c0 7488 }
            // n = 6, score = 2400
            //   53                   | push                ebx
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   c745fcff070000       | mov                 dword ptr [ebp - 4], 0x7ff
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7488                 | je                  0xffffff8a

        $sequence_1 = { e8???????? e9???????? 8d45f0 c645f001 51 50 }
            // n = 6, score = 2400
            //   e8????????           |                     
            //   e9????????           |                     
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   c645f001             | mov                 byte ptr [ebp - 0x10], 1
            //   51                   | push                ecx
            //   50                   | push                eax

        $sequence_2 = { 7403 832700 8b5d14 33f6 83fb01 7507 }
            // n = 6, score = 2400
            //   7403                 | je                  5
            //   832700               | and                 dword ptr [edi], 0
            //   8b5d14               | mov                 ebx, dword ptr [ebp + 0x14]
            //   33f6                 | xor                 esi, esi
            //   83fb01               | cmp                 ebx, 1
            //   7507                 | jne                 9

        $sequence_3 = { 394708 7417 684c0e0000 68???????? 68???????? }
            // n = 5, score = 2400
            //   394708               | cmp                 dword ptr [edi + 8], eax
            //   7417                 | je                  0x19
            //   684c0e0000           | push                0xe4c
            //   68????????           |                     
            //   68????????           |                     

        $sequence_4 = { 51 8bc2 8945fc 56 8bf1 }
            // n = 5, score = 2400
            //   51                   | push                ecx
            //   8bc2                 | mov                 eax, edx
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   56                   | push                esi
            //   8bf1                 | mov                 esi, ecx

        $sequence_5 = { 8d4dfc 51 8d4df8 c745ec02000000 51 }
            // n = 5, score = 2400
            //   8d4dfc               | lea                 ecx, [ebp - 4]
            //   51                   | push                ecx
            //   8d4df8               | lea                 ecx, [ebp - 8]
            //   c745ec02000000       | mov                 dword ptr [ebp - 0x14], 2
            //   51                   | push                ecx

        $sequence_6 = { 56 57 e8???????? 83c414 ff75f4 ff15???????? }
            // n = 6, score = 2400
            //   56                   | push                esi
            //   57                   | push                edi
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   ff75f4               | push                dword ptr [ebp - 0xc]
            //   ff15????????         |                     

        $sequence_7 = { 8d45ec c706???????? 50 53 ff75e4 895dec ff15???????? }
            // n = 7, score = 2400
            //   8d45ec               | lea                 eax, [ebp - 0x14]
            //   c706????????         |                     
            //   50                   | push                eax
            //   53                   | push                ebx
            //   ff75e4               | push                dword ptr [ebp - 0x1c]
            //   895dec               | mov                 dword ptr [ebp - 0x14], ebx
            //   ff15????????         |                     

        $sequence_8 = { 8d55cc ff75cc 52 ff5024 807dcc00 6a04 58 }
            // n = 7, score = 2400
            //   8d55cc               | lea                 edx, [ebp - 0x34]
            //   ff75cc               | push                dword ptr [ebp - 0x34]
            //   52                   | push                edx
            //   ff5024               | call                dword ptr [eax + 0x24]
            //   807dcc00             | cmp                 byte ptr [ebp - 0x34], 0
            //   6a04                 | push                4
            //   58                   | pop                 eax

        $sequence_9 = { 8975e4 894df0 33c0 40 8945fc }
            // n = 5, score = 2400
            //   8975e4               | mov                 dword ptr [ebp - 0x1c], esi
            //   894df0               | mov                 dword ptr [ebp - 0x10], ecx
            //   33c0                 | xor                 eax, eax
            //   40                   | inc                 eax
            //   8945fc               | mov                 dword ptr [ebp - 4], eax

    condition:
        7 of them and filesize < 1212416
}