rule win_rad_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.rad."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rad"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d8d9cfdffff c645fc1a ff15???????? c645fc19 }
            // n = 4, score = 100
            //   8d8d9cfdffff         | lea                 ecx, [ebp - 0x264]
            //   c645fc1a             | mov                 byte ptr [ebp - 4], 0x1a
            //   ff15????????         |                     
            //   c645fc19             | mov                 byte ptr [ebp - 4], 0x19

        $sequence_1 = { 51 ff15???????? 83c404 33c0 8945c8 }
            // n = 5, score = 100
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   83c404               | add                 esp, 4
            //   33c0                 | xor                 eax, eax
            //   8945c8               | mov                 dword ptr [ebp - 0x38], eax

        $sequence_2 = { 5b c3 83fefe 760b }
            // n = 4, score = 100
            //   5b                   | pop                 ebx
            //   c3                   | ret                 
            //   83fefe               | cmp                 esi, -2
            //   760b                 | jbe                 0xd

        $sequence_3 = { 8d8f10030000 c684240c06000016 ff15???????? 8d4c2458 c684240806000015 ffd3 39742450 }
            // n = 7, score = 100
            //   8d8f10030000         | lea                 ecx, [edi + 0x310]
            //   c684240c06000016     | mov                 byte ptr [esp + 0x60c], 0x16
            //   ff15????????         |                     
            //   8d4c2458             | lea                 ecx, [esp + 0x58]
            //   c684240806000015     | mov                 byte ptr [esp + 0x608], 0x15
            //   ffd3                 | call                ebx
            //   39742450             | cmp                 dword ptr [esp + 0x50], esi

        $sequence_4 = { 89742410 c684240001000006 85f6 7447 8bce ff15???????? c706???????? }
            // n = 7, score = 100
            //   89742410             | mov                 dword ptr [esp + 0x10], esi
            //   c684240001000006     | mov                 byte ptr [esp + 0x100], 6
            //   85f6                 | test                esi, esi
            //   7447                 | je                  0x49
            //   8bce                 | mov                 ecx, esi
            //   ff15????????         |                     
            //   c706????????         |                     

        $sequence_5 = { e8???????? 8d4c2434 68???????? 51 e8???????? 8b35???????? 6a14 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8d4c2434             | lea                 ecx, [esp + 0x34]
            //   68????????           |                     
            //   51                   | push                ecx
            //   e8????????           |                     
            //   8b35????????         |                     
            //   6a14                 | push                0x14

        $sequence_6 = { ff25???????? 8db514faffff e9???????? 8db530faffff e9???????? 8d8d4cfaffff }
            // n = 6, score = 100
            //   ff25????????         |                     
            //   8db514faffff         | lea                 esi, [ebp - 0x5ec]
            //   e9????????           |                     
            //   8db530faffff         | lea                 esi, [ebp - 0x5d0]
            //   e9????????           |                     
            //   8d8d4cfaffff         | lea                 ecx, [ebp - 0x5b4]

        $sequence_7 = { 8b75e0 8bd6 83fe06 7205 }
            // n = 4, score = 100
            //   8b75e0               | mov                 esi, dword ptr [ebp - 0x20]
            //   8bd6                 | mov                 edx, esi
            //   83fe06               | cmp                 esi, 6
            //   7205                 | jb                  7

        $sequence_8 = { 8975b0 eb03 897db0 8b55b0 8955ac c645fc04 }
            // n = 6, score = 100
            //   8975b0               | mov                 dword ptr [ebp - 0x50], esi
            //   eb03                 | jmp                 5
            //   897db0               | mov                 dword ptr [ebp - 0x50], edi
            //   8b55b0               | mov                 edx, dword ptr [ebp - 0x50]
            //   8955ac               | mov                 dword ptr [ebp - 0x54], edx
            //   c645fc04             | mov                 byte ptr [ebp - 4], 4

        $sequence_9 = { 59 8be5 5d c20400 8d4df0 c645fc00 ff15???????? }
            // n = 7, score = 100
            //   59                   | pop                 ecx
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c20400               | ret                 4
            //   8d4df0               | lea                 ecx, [ebp - 0x10]
            //   c645fc00             | mov                 byte ptr [ebp - 4], 0
            //   ff15????????         |                     

    condition:
        7 of them and filesize < 207872
}