rule win_radamant_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.radamant."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.radamant"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b45f0 f7d0 2345f4 09d0 0345c4 0345ec }
            // n = 6, score = 100
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   f7d0                 | not                 eax
            //   2345f4               | and                 eax, dword ptr [ebp - 0xc]
            //   09d0                 | or                  eax, edx
            //   0345c4               | add                 eax, dword ptr [ebp - 0x3c]
            //   0345ec               | add                 eax, dword ptr [ebp - 0x14]

        $sequence_1 = { 7519 8b45c4 890424 e8???????? 8b45f4 8985f4fdffff e9???????? }
            // n = 7, score = 100
            //   7519                 | jne                 0x1b
            //   8b45c4               | mov                 eax, dword ptr [ebp - 0x3c]
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   8985f4fdffff         | mov                 dword ptr [ebp - 0x20c], eax
            //   e9????????           |                     

        $sequence_2 = { 8b5510 83c20e 8b45ec c1e808 8802 8b5510 83c20f }
            // n = 7, score = 100
            //   8b5510               | mov                 edx, dword ptr [ebp + 0x10]
            //   83c20e               | add                 edx, 0xe
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   c1e808               | shr                 eax, 8
            //   8802                 | mov                 byte ptr [edx], al
            //   8b5510               | mov                 edx, dword ptr [ebp + 0x10]
            //   83c20f               | add                 edx, 0xf

        $sequence_3 = { 31c2 8b45e8 c1e808 0fb6c0 0fb680b0094100 }
            // n = 5, score = 100
            //   31c2                 | xor                 edx, eax
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]
            //   c1e808               | shr                 eax, 8
            //   0fb6c0               | movzx               eax, al
            //   0fb680b0094100       | movzx               eax, byte ptr [eax + 0x4109b0]

        $sequence_4 = { 8901 8b4df4 83c128 8b55f4 83c208 8b45f4 83c024 }
            // n = 7, score = 100
            //   8901                 | mov                 dword ptr [ecx], eax
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   83c128               | add                 ecx, 0x28
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]
            //   83c208               | add                 edx, 8
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   83c024               | add                 eax, 0x24

        $sequence_5 = { 8d85a4fcffff ff00 8d85b8fdffff 890424 e8???????? 3985a4fcffff }
            // n = 6, score = 100
            //   8d85a4fcffff         | lea                 eax, [ebp - 0x35c]
            //   ff00                 | inc                 dword ptr [eax]
            //   8d85b8fdffff         | lea                 eax, [ebp - 0x248]
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   3985a4fcffff         | cmp                 dword ptr [ebp - 0x35c], eax

        $sequence_6 = { c7042400000000 e8???????? 83ec0c 8d85b8fdffff 890424 e8???????? 8985a4fcffff }
            // n = 7, score = 100
            //   c7042400000000       | mov                 dword ptr [esp], 0
            //   e8????????           |                     
            //   83ec0c               | sub                 esp, 0xc
            //   8d85b8fdffff         | lea                 eax, [ebp - 0x248]
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   8985a4fcffff         | mov                 dword ptr [ebp - 0x35c], eax

        $sequence_7 = { 8b45f4 8b00 c1e810 0fb6c0 8b0485e02f4100 8b1495e02b4100 31c2 }
            // n = 7, score = 100
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   c1e810               | shr                 eax, 0x10
            //   0fb6c0               | movzx               eax, al
            //   8b0485e02f4100       | mov                 eax, dword ptr [eax*4 + 0x412fe0]
            //   8b1495e02b4100       | mov                 edx, dword ptr [edx*4 + 0x412be0]
            //   31c2                 | xor                 edx, eax

        $sequence_8 = { 09d0 0345a8 0345f4 2d885b9528 8945f4 8d45f4 c10007 }
            // n = 7, score = 100
            //   09d0                 | or                  eax, edx
            //   0345a8               | add                 eax, dword ptr [ebp - 0x58]
            //   0345f4               | add                 eax, dword ptr [ebp - 0xc]
            //   2d885b9528           | sub                 eax, 0x28955b88
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   c10007               | rol                 dword ptr [eax], 7

        $sequence_9 = { c1e818 0fb6c0 8b0485b01b4100 8b12 31c2 }
            // n = 5, score = 100
            //   c1e818               | shr                 eax, 0x18
            //   0fb6c0               | movzx               eax, al
            //   8b0485b01b4100       | mov                 eax, dword ptr [eax*4 + 0x411bb0]
            //   8b12                 | mov                 edx, dword ptr [edx]
            //   31c2                 | xor                 edx, eax

    condition:
        7 of them and filesize < 204800
}