rule win_radrat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.radrat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.radrat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c645fc06 8d9578ffffff 52 83ec28 8bc4 89a520ffffff 8d4dcc }
            // n = 7, score = 100
            //   c645fc06             | mov                 byte ptr [ebp - 4], 6
            //   8d9578ffffff         | lea                 edx, [ebp - 0x88]
            //   52                   | push                edx
            //   83ec28               | sub                 esp, 0x28
            //   8bc4                 | mov                 eax, esp
            //   89a520ffffff         | mov                 dword ptr [ebp - 0xe0], esp
            //   8d4dcc               | lea                 ecx, [ebp - 0x34]

        $sequence_1 = { 8b55d8 894a54 837df010 7404 0cff eb7b 8b45d8 }
            // n = 7, score = 100
            //   8b55d8               | mov                 edx, dword ptr [ebp - 0x28]
            //   894a54               | mov                 dword ptr [edx + 0x54], ecx
            //   837df010             | cmp                 dword ptr [ebp - 0x10], 0x10
            //   7404                 | je                  6
            //   0cff                 | or                  al, 0xff
            //   eb7b                 | jmp                 0x7d
            //   8b45d8               | mov                 eax, dword ptr [ebp - 0x28]

        $sequence_2 = { 8d8db4c3ffff e8???????? e9???????? 83bd54ffffff46 0f8570110000 6a01 8d953cc3ffff }
            // n = 7, score = 100
            //   8d8db4c3ffff         | lea                 ecx, [ebp - 0x3c4c]
            //   e8????????           |                     
            //   e9????????           |                     
            //   83bd54ffffff46       | cmp                 dword ptr [ebp - 0xac], 0x46
            //   0f8570110000         | jne                 0x1176
            //   6a01                 | push                1
            //   8d953cc3ffff         | lea                 edx, [ebp - 0x3cc4]

        $sequence_3 = { e8???????? c3 8d8d8ccdffff e8???????? c3 8d8dac95ffff e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   c3                   | ret                 
            //   8d8d8ccdffff         | lea                 ecx, [ebp - 0x3274]
            //   e8????????           |                     
            //   c3                   | ret                 
            //   8d8dac95ffff         | lea                 ecx, [ebp - 0x6a54]
            //   e8????????           |                     

        $sequence_4 = { e8???????? c3 8d4d80 e8???????? c3 8d8d18fdffff e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   c3                   | ret                 
            //   8d4d80               | lea                 ecx, [ebp - 0x80]
            //   e8????????           |                     
            //   c3                   | ret                 
            //   8d8d18fdffff         | lea                 ecx, [ebp - 0x2e8]
            //   e8????????           |                     

        $sequence_5 = { e8???????? c745c000000000 eb09 8b45c0 83c001 8945c0 8b4dc0 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   c745c000000000       | mov                 dword ptr [ebp - 0x40], 0
            //   eb09                 | jmp                 0xb
            //   8b45c0               | mov                 eax, dword ptr [ebp - 0x40]
            //   83c001               | add                 eax, 1
            //   8945c0               | mov                 dword ptr [ebp - 0x40], eax
            //   8b4dc0               | mov                 ecx, dword ptr [ebp - 0x40]

        $sequence_6 = { c745fc00000000 8b45c0 50 8b4dc8 e8???????? c745fcffffffff 8d4dcc }
            // n = 7, score = 100
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   8b45c0               | mov                 eax, dword ptr [ebp - 0x40]
            //   50                   | push                eax
            //   8b4dc8               | mov                 ecx, dword ptr [ebp - 0x38]
            //   e8????????           |                     
            //   c745fcffffffff       | mov                 dword ptr [ebp - 4], 0xffffffff
            //   8d4dcc               | lea                 ecx, [ebp - 0x34]

        $sequence_7 = { c68522ffffff00 c68524ffffff00 c645fc07 8b550c 52 8d8decfeffff e8???????? }
            // n = 7, score = 100
            //   c68522ffffff00       | mov                 byte ptr [ebp - 0xde], 0
            //   c68524ffffff00       | mov                 byte ptr [ebp - 0xdc], 0
            //   c645fc07             | mov                 byte ptr [ebp - 4], 7
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   52                   | push                edx
            //   8d8decfeffff         | lea                 ecx, [ebp - 0x114]
            //   e8????????           |                     

        $sequence_8 = { e8???????? 83c410 8845fc 8b4dfc 81e1ff000000 85c9 7411 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   8845fc               | mov                 byte ptr [ebp - 4], al
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   81e1ff000000         | and                 ecx, 0xff
            //   85c9                 | test                ecx, ecx
            //   7411                 | je                  0x13

        $sequence_9 = { e8???????? c645fc08 8b8d6cfbffff 83c108 e8???????? c645fc04 8d8ddefdffff }
            // n = 7, score = 100
            //   e8????????           |                     
            //   c645fc08             | mov                 byte ptr [ebp - 4], 8
            //   8b8d6cfbffff         | mov                 ecx, dword ptr [ebp - 0x494]
            //   83c108               | add                 ecx, 8
            //   e8????????           |                     
            //   c645fc04             | mov                 byte ptr [ebp - 4], 4
            //   8d8ddefdffff         | lea                 ecx, [ebp - 0x222]

    condition:
        7 of them and filesize < 2080768
}