rule win_ragnarok_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ragnarok."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ragnarok"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c1f906 57 6bf838 894df4 8b048d28754300 8b540718 8955ec }
            // n = 7, score = 200
            //   c1f906               | sar                 ecx, 6
            //   57                   | push                edi
            //   6bf838               | imul                edi, eax, 0x38
            //   894df4               | mov                 dword ptr [ebp - 0xc], ecx
            //   8b048d28754300       | mov                 eax, dword ptr [ecx*4 + 0x437528]
            //   8b540718             | mov                 edx, dword ptr [edi + eax + 0x18]
            //   8955ec               | mov                 dword ptr [ebp - 0x14], edx

        $sequence_1 = { 8945b8 8b45a8 8bc8 2345b0 f7d1 234d98 c1c20a }
            // n = 7, score = 200
            //   8945b8               | mov                 dword ptr [ebp - 0x48], eax
            //   8b45a8               | mov                 eax, dword ptr [ebp - 0x58]
            //   8bc8                 | mov                 ecx, eax
            //   2345b0               | and                 eax, dword ptr [ebp - 0x50]
            //   f7d1                 | not                 ecx
            //   234d98               | and                 ecx, dword ptr [ebp - 0x68]
            //   c1c20a               | rol                 edx, 0xa

        $sequence_2 = { 0f1f4000 8bc8 8b4104 85c0 75f7 895104 8b9db4feffff }
            // n = 7, score = 200
            //   0f1f4000             | nop                 dword ptr [eax]
            //   8bc8                 | mov                 ecx, eax
            //   8b4104               | mov                 eax, dword ptr [ecx + 4]
            //   85c0                 | test                eax, eax
            //   75f7                 | jne                 0xfffffff9
            //   895104               | mov                 dword ptr [ecx + 4], edx
            //   8b9db4feffff         | mov                 ebx, dword ptr [ebp - 0x14c]

        $sequence_3 = { 8bc6 f7d0 c1c208 03550c 0bc7 33c3 8955bc }
            // n = 7, score = 200
            //   8bc6                 | mov                 eax, esi
            //   f7d0                 | not                 eax
            //   c1c208               | rol                 edx, 8
            //   03550c               | add                 edx, dword ptr [ebp + 0xc]
            //   0bc7                 | or                  eax, edi
            //   33c3                 | xor                 eax, ebx
            //   8955bc               | mov                 dword ptr [ebp - 0x44], edx

        $sequence_4 = { 8b96e0000000 83fa14 7d38 8d0492 8d0c86 8d0492 c781e4000000e0b04000 }
            // n = 7, score = 200
            //   8b96e0000000         | mov                 edx, dword ptr [esi + 0xe0]
            //   83fa14               | cmp                 edx, 0x14
            //   7d38                 | jge                 0x3a
            //   8d0492               | lea                 eax, [edx + edx*4]
            //   8d0c86               | lea                 ecx, [esi + eax*4]
            //   8d0492               | lea                 eax, [edx + edx*4]
            //   c781e4000000e0b04000     | mov    dword ptr [ecx + 0xe4], 0x40b0e0

        $sequence_5 = { 8b7d08 0fb6ca 333c8d105d4300 8bcf 897d08 334814 894d08 }
            // n = 7, score = 200
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   0fb6ca               | movzx               ecx, dl
            //   333c8d105d4300       | xor                 edi, dword ptr [ecx*4 + 0x435d10]
            //   8bcf                 | mov                 ecx, edi
            //   897d08               | mov                 dword ptr [ebp + 8], edi
            //   334814               | xor                 ecx, dword ptr [eax + 0x14]
            //   894d08               | mov                 dword ptr [ebp + 8], ecx

        $sequence_6 = { 3a8a54d84200 7532 8b06 8a08 40 42 8906 }
            // n = 7, score = 200
            //   3a8a54d84200         | cmp                 cl, byte ptr [edx + 0x42d854]
            //   7532                 | jne                 0x34
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   8a08                 | mov                 cl, byte ptr [eax]
            //   40                   | inc                 eax
            //   42                   | inc                 edx
            //   8906                 | mov                 dword ptr [esi], eax

        $sequence_7 = { c1c10a 89459c 81c6a1ebd96e 8bc2 894d98 }
            // n = 5, score = 200
            //   c1c10a               | rol                 ecx, 0xa
            //   89459c               | mov                 dword ptr [ebp - 0x64], eax
            //   81c6a1ebd96e         | add                 esi, 0x6ed9eba1
            //   8bc2                 | mov                 eax, edx
            //   894d98               | mov                 dword ptr [ebp - 0x68], ecx

        $sequence_8 = { 234db4 03c3 894598 8b45b8 23c2 c145b80a 0bc8 }
            // n = 7, score = 200
            //   234db4               | and                 ecx, dword ptr [ebp - 0x4c]
            //   03c3                 | add                 eax, ebx
            //   894598               | mov                 dword ptr [ebp - 0x68], eax
            //   8b45b8               | mov                 eax, dword ptr [ebp - 0x48]
            //   23c2                 | and                 eax, edx
            //   c145b80a             | rol                 dword ptr [ebp - 0x48], 0xa
            //   0bc8                 | or                  ecx, eax

        $sequence_9 = { 8b0c8d28754300 88440f2b 83fa03 7511 8b45fc 8b0c8528754300 8a06 }
            // n = 7, score = 200
            //   8b0c8d28754300       | mov                 ecx, dword ptr [ecx*4 + 0x437528]
            //   88440f2b             | mov                 byte ptr [edi + ecx + 0x2b], al
            //   83fa03               | cmp                 edx, 3
            //   7511                 | jne                 0x13
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b0c8528754300       | mov                 ecx, dword ptr [eax*4 + 0x437528]
            //   8a06                 | mov                 al, byte ptr [esi]

    condition:
        7 of them and filesize < 483328
}