rule win_ralord_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ralord."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ralord"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7473 66813e4250 488d05d0a30100 7465 66813e5246 488d05c1a30100 7457 }
            // n = 7, score = 100
            //   7473                 | je                  0x11e
            //   66813e4250           | dec                 eax
            //   488d05d0a30100       | mov                 ebx, ecx
            //   7465                 | xor                 edi, edi
            //   66813e5246           | dec                 esp
            //   488d05c1a30100       | lea                 esi, [0x183b6]
            //   7457                 | xor                 esi, esi

        $sequence_1 = { 490b8818080000 756c 4c89c1 4889c6 e8???????? 4889f0 eb5c }
            // n = 7, score = 100
            //   490b8818080000       | lea                 edx, [0x174ee]
            //   756c                 | dec                 eax
            //   4c89c1               | inc                 edx
            //   4889c6               | dec                 ecx
            //   e8????????           |                     
            //   4889f0               | cmp                 eax, edx
            //   eb5c                 | jne                 0xe3

        $sequence_2 = { 4929d0 0f82c9000000 4939fc 0f87d2000000 4c01f2 4889f1 e8???????? }
            // n = 7, score = 100
            //   4929d0               | dec                 eax
            //   0f82c9000000         | cmp                 ecx, 0xf
            //   4939fc               | dec                 eax
            //   0f87d2000000         | mov                 ecx, edx
            //   4c01f2               | ja                  0xffffffe3
            //   4889f1               | jmp                 0x57
            //   e8????????           |                     

        $sequence_3 = { 4801f0 4829d0 4839f0 0f83bb020000 4d8d7b01 410fb60406 4138040e }
            // n = 7, score = 100
            //   4801f0               | pcmpeqb             xmm0, xmm6
            //   4829d0               | pmovmskb            eax, xmm0
            //   4839f0               | inc                 ebp
            //   0f83bb020000         | xor                 ebx, ebx
            //   4d8d7b01             | cmp                 byte ptr [ecx + 0xfe], 0xc0
            //   410fb60406           | inc                 ecx
            //   4138040e             | setge               bl

        $sequence_4 = { 48837d2000 7406 807d2f00 7409 4883c428 5b 5f }
            // n = 7, score = 100
            //   48837d2000           | pop                 ebp
            //   7406                 | ret                 
            //   807d2f00             | dec                 eax
            //   7409                 | lea                 eax, [0x2e269]
            //   4883c428             | mov                 edx, 0x20
            //   5b                   | dec                 esp
            //   5f                   | mov                 ecx, eax

        $sequence_5 = { 752a 488b4e20 488b4628 488d15522b0100 41b801000000 ff5018 89c1 }
            // n = 7, score = 100
            //   752a                 | dec                 eax
            //   488b4e20             | mov                 dword ptr [ebp], eax
            //   488b4628             | dec                 eax
            //   488d15522b0100       | mov                 eax, ebp
            //   41b801000000         | dec                 eax
            //   ff5018               | mov                 dword ptr [ebp - 0x40], eax
            //   89c1                 | dec                 eax

        $sequence_6 = { 0f80de010000 4839fa 7550 4c8b4dd0 4c89c8 48f7d8 0f80c9010000 }
            // n = 7, score = 100
            //   0f80de010000         | inc                 ecx
            //   4839fa               | mov                 esi, 0
            //   7550                 | test                al, 1
            //   4c8b4dd0             | jne                 0xa3
            //   4c89c8               | jmp                 0xba
            //   48f7d8               | xorps               xmm0, xmm0
            //   0f80c9010000         | movups              xmmword ptr [ebp + 0xa8], xmm0

        $sequence_7 = { 4889f1 eb27 89442430 488d0551850200 4889442420 488d15a0850200 488d4c2440 }
            // n = 7, score = 100
            //   4889f1               | dec                 eax
            //   eb27                 | add                 esp, 0x2f0
            //   89442430             | dec                 eax
            //   488d0551850200       | mov                 ecx, esi
            //   4889442420           | dec                 eax
            //   488d15a0850200       | mov                 edx, edi
            //   488d4c2440           | dec                 eax

        $sequence_8 = { 488d0daf640100 ba10000000 e8???????? 41b601 84c0 0f85b7000000 48c70600000000 }
            // n = 7, score = 100
            //   488d0daf640100       | jne                 0xffffff35
            //   ba10000000           | dec                 eax
            //   e8????????           |                     
            //   41b601               | lea                 edx, [0x13f89]
            //   84c0                 | dec                 eax
            //   0f85b7000000         | lea                 ecx, [ebp - 0x20]
            //   48c70600000000       | dec                 eax

        $sequence_9 = { 400f90c6 430fb6141a 83c2d0 83fa09 0f87aa090000 }
            // n = 5, score = 100
            //   400f90c6             | movzx               edx, byte ptr [ecx + eax]
            //   430fb6141a           | add                 edx, -0x30
            //   83c2d0               | xor                 eax, eax
            //   83fa09               | inc                 ecx
            //   0f87aa090000         | xchg                byte ptr [ebp], al

    condition:
        7 of them and filesize < 798720
}