rule win_ramdo_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ramdo."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ramdo"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 68b3030442 6a00 6a00 e8???????? }
            // n = 5, score = 600
            //   e8????????           |                     
            //   68b3030442           | push                0x420403b3
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   e8????????           |                     

        $sequence_1 = { 68bc882a42 6a03 6a00 e8???????? }
            // n = 4, score = 600
            //   68bc882a42           | push                0x422a88bc
            //   6a03                 | push                3
            //   6a00                 | push                0
            //   e8????????           |                     

        $sequence_2 = { 6894dac0dc 6a00 6a00 e8???????? }
            // n = 4, score = 600
            //   6894dac0dc           | push                0xdcc0da94
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   e8????????           |                     

        $sequence_3 = { ff55f8 8945fc 837dfcff 7411 }
            // n = 4, score = 600
            //   ff55f8               | call                dword ptr [ebp - 8]
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   837dfcff             | cmp                 dword ptr [ebp - 4], -1
            //   7411                 | je                  0x13

        $sequence_4 = { 68dd786eac 6a03 6a00 e8???????? }
            // n = 4, score = 600
            //   68dd786eac           | push                0xac6e78dd
            //   6a03                 | push                3
            //   6a00                 | push                0
            //   e8????????           |                     

        $sequence_5 = { 68c07b3072 6a03 6a00 e8???????? }
            // n = 4, score = 600
            //   68c07b3072           | push                0x72307bc0
            //   6a03                 | push                3
            //   6a00                 | push                0
            //   e8????????           |                     

        $sequence_6 = { 68b6b2cff5 6a03 6a00 e8???????? }
            // n = 4, score = 600
            //   68b6b2cff5           | push                0xf5cfb2b6
            //   6a03                 | push                3
            //   6a00                 | push                0
            //   e8????????           |                     

        $sequence_7 = { 68b928ece1 6a03 6a00 e8???????? }
            // n = 4, score = 600
            //   68b928ece1           | push                0xe1ec28b9
            //   6a03                 | push                3
            //   6a00                 | push                0
            //   e8????????           |                     

        $sequence_8 = { 68b900308a 6a01 6a00 e8???????? }
            // n = 4, score = 600
            //   68b900308a           | push                0x8a3000b9
            //   6a01                 | push                1
            //   6a00                 | push                0
            //   e8????????           |                     

        $sequence_9 = { 68c29e34ea 6a03 6a00 e8???????? }
            // n = 4, score = 600
            //   68c29e34ea           | push                0xea349ec2
            //   6a03                 | push                3
            //   6a00                 | push                0
            //   e8????????           |                     

    condition:
        7 of them and filesize < 548864
}