rule win_ransomexx_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ransomexx."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ransomexx"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c1eb08 81e3ff000000 333c9db07a4200 8b5dec }
            // n = 4, score = 100
            //   c1eb08               | shr                 ebx, 8
            //   81e3ff000000         | and                 ebx, 0xff
            //   333c9db07a4200       | xor                 edi, dword ptr [ebx*4 + 0x427ab0]
            //   8b5dec               | mov                 ebx, dword ptr [ebp - 0x14]

        $sequence_1 = { 8a10 881406 40 49 75f7 8b7df0 }
            // n = 6, score = 100
            //   8a10                 | mov                 dl, byte ptr [eax]
            //   881406               | mov                 byte ptr [esi + eax], dl
            //   40                   | inc                 eax
            //   49                   | dec                 ecx
            //   75f7                 | jne                 0xfffffff9
            //   8b7df0               | mov                 edi, dword ptr [ebp - 0x10]

        $sequence_2 = { 8b0d???????? 6a04 8d45e8 6a00 50 ffd1 }
            // n = 6, score = 100
            //   8b0d????????         |                     
            //   6a04                 | push                4
            //   8d45e8               | lea                 eax, [ebp - 0x18]
            //   6a00                 | push                0
            //   50                   | push                eax
            //   ffd1                 | call                ecx

        $sequence_3 = { 6a00 ff15???????? 85c0 7415 0fb745e0 8b0d???????? }
            // n = 6, score = 100
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7415                 | je                  0x17
            //   0fb745e0             | movzx               eax, word ptr [ebp - 0x20]
            //   8b0d????????         |                     

        $sequence_4 = { 8d3c8500000000 8b0417 53 50 ff15???????? eb31 }
            // n = 6, score = 100
            //   8d3c8500000000       | lea                 edi, [eax*4]
            //   8b0417               | mov                 eax, dword ptr [edi + edx]
            //   53                   | push                ebx
            //   50                   | push                eax
            //   ff15????????         |                     
            //   eb31                 | jmp                 0x33

        $sequence_5 = { b801000000 8945dc 8945e0 33f2 }
            // n = 4, score = 100
            //   b801000000           | mov                 eax, 1
            //   8945dc               | mov                 dword ptr [ebp - 0x24], eax
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax
            //   33f2                 | xor                 esi, edx

        $sequence_6 = { 3b45ec 729b 8b4d10 8b5104 8955fc }
            // n = 5, score = 100
            //   3b45ec               | cmp                 eax, dword ptr [ebp - 0x14]
            //   729b                 | jb                  0xffffff9d
            //   8b4d10               | mov                 ecx, dword ptr [ebp + 0x10]
            //   8b5104               | mov                 edx, dword ptr [ecx + 4]
            //   8955fc               | mov                 dword ptr [ebp - 4], edx

        $sequence_7 = { 8d5df4 8d75e0 8bc3 e8???????? 8bf0 85f6 }
            // n = 6, score = 100
            //   8d5df4               | lea                 ebx, [ebp - 0xc]
            //   8d75e0               | lea                 esi, [ebp - 0x20]
            //   8bc3                 | mov                 eax, ebx
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi

        $sequence_8 = { b16c c7006e74646c c740046c2e646c 884808 50 ff15???????? }
            // n = 6, score = 100
            //   b16c                 | mov                 cl, 0x6c
            //   c7006e74646c         | mov                 dword ptr [eax], 0x6c64746e
            //   c740046c2e646c       | mov                 dword ptr [eax + 4], 0x6c642e6c
            //   884808               | mov                 byte ptr [eax + 8], cl
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_9 = { e8???????? 83c404 85c0 7520 8b4dfc f7d9 890f }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   85c0                 | test                eax, eax
            //   7520                 | jne                 0x22
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   f7d9                 | neg                 ecx
            //   890f                 | mov                 dword ptr [edi], ecx

    condition:
        7 of them and filesize < 372736
}