rule win_ransomhub_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ransomhub."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ransomhub"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { eb0f 488d3dbb5d5100 0f1f00 e8???????? e8???????? 48891d???????? 833d????????00 }
            // n = 7, score = 100
            //   eb0f                 | mov                 eax, edx
            //   488d3dbb5d5100       | mov                 edi, 1
            //   0f1f00               | dec                 eax
            //   e8????????           |                     
            //   e8????????           |                     
            //   48891d????????       |                     
            //   833d????????00       |                     

        $sequence_1 = { e8???????? 488d3d03f63300 0f1f00 e8???????? e8???????? 4889842430190000 48899c24b00a0000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488d3d03f63300       | dec                 ebp
            //   0f1f00               | lea                 esp, [ecx + edx]
            //   e8????????           |                     
            //   e8????????           |                     
            //   4889842430190000     | dec                 ecx
            //   48899c24b00a0000     | cmp                 ebx, 0xd

        $sequence_2 = { bb07000000 488bac2488000000 4881c490000000 c3 488d058db90b00 bb07000000 488bac2488000000 }
            // n = 7, score = 100
            //   bb07000000           | dec                 eax
            //   488bac2488000000     | mov                 ebx, ecx
            //   4881c490000000       | dec                 eax
            //   c3                   | lea                 esi, [0x2c4dc9]
            //   488d058db90b00       | dec                 eax
            //   bb07000000           | mov                 esi, dword ptr [esp + 0x60]
            //   488bac2488000000     | dec                 eax

        $sequence_3 = { bf01000000 488b8424f00b0000 e8???????? 4c8b8c24f00b0000 41ff8980000000 488b8c2488030000 488b8424b8030000 }
            // n = 7, score = 100
            //   bf01000000           | cmp                 eax, 0xe
            //   488b8424f00b0000     | dec                 eax
            //   e8????????           |                     
            //   4c8b8c24f00b0000     | lea                 edi, [0x515b16]
            //   41ff8980000000       | dec                 eax
            //   488b8c2488030000     | mov                 edx, 0x84b4e6f6
            //   488b8424b8030000     | stc                 

        $sequence_4 = { b90f000000 e8???????? 48898424000e0000 48899c24b8000000 488b15???????? 48899424c0110000 488d0580fd2800 }
            // n = 7, score = 100
            //   b90f000000           | mov                 ecx, dword ptr [esp + 0x40]
            //   e8????????           |                     
            //   48898424000e0000     | dec                 esp
            //   48899c24b8000000     | mov                 edx, dword ptr [esp + 0xb8]
            //   488b15????????       |                     
            //   48899424c0110000     | dec                 eax
            //   488d0580fd2800       | lea                 esi, [0x1d2a]

        $sequence_5 = { 48c744243400000000 0fb6542449 0fb6742443 01f2 0fb6742442 0fb67c244c 440fb6442457 }
            // n = 7, score = 100
            //   48c744243400000000     | inc    ebp
            //   0fb6542449           | xor                 edx, edx
            //   0fb6742443           | dec                 eax
            //   01f2                 | mov                 dword ptr [esp + 0x70], ebx
            //   0fb6742442           | dec                 eax
            //   0fb67c244c           | mov                 dword ptr [esp + 0x50], eax
            //   440fb6442457         | dec                 eax

        $sequence_6 = { eb09 4889c7 90 e8???????? 488d05d40d2f00 488b5c2438 488d0db3af3300 }
            // n = 7, score = 100
            //   eb09                 | lea                 eax, [0x1e49ca]
            //   4889c7               | dec                 esp
            //   90                   | mov                 ecx, eax
            //   e8????????           |                     
            //   488d05d40d2f00       | dec                 eax
            //   488b5c2438           | mov                 ebx, ecx
            //   488d0db3af3300       | nop                 dword ptr [eax]

        $sequence_7 = { 4d8d0cb0 4d8d49fc 450fb609 488d4701 4839c1 0f86ff000000 4829f2 }
            // n = 7, score = 100
            //   4d8d0cb0             | dec                 eax
            //   4d8d49fc             | cmp                 dword ptr [edx + 0x70], 0
            //   450fb609             | jne                 0x88c
            //   488d4701             | dec                 eax
            //   4839c1               | mov                 ecx, ebx
            //   0f86ff000000         | dec                 eax
            //   4829f2               | mov                 esi, edi

        $sequence_8 = { c3 80fb2d 0f85be010000 8400 833d????????00 750c 488d0dbdfa2800 }
            // n = 7, score = 100
            //   c3                   | dec                 eax
            //   80fb2d               | lea                 edi, [eax + 0x18]
            //   0f85be010000         | dec                 eax
            //   8400                 | mov                 ecx, dword ptr [esp + 0x580]
            //   833d????????00       |                     
            //   750c                 | nop                 dword ptr [eax]
            //   488d0dbdfa2800       | dec                 eax

        $sequence_9 = { e8???????? 4889442428 48c70000000000 488d05b41b0700 e8???????? 4889442420 488d05a3ea0900 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   4889442428           | jmp                 0x22a
            //   48c70000000000       | dec                 eax
            //   488d05b41b0700       | mov                 dword ptr [eax + 8], 6
            //   e8????????           |                     
            //   4889442420           | dec                 eax
            //   488d05a3ea0900       | lea                 ecx, [0x133d32]

    condition:
        7 of them and filesize < 12821504
}