rule win_rarog_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.rarog."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rarog"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b8c246c030000 33cc e8???????? 8be5 5d c3 55 }
            // n = 7, score = 100
            //   8b8c246c030000       | mov                 ecx, dword ptr [esp + 0x36c]
            //   33cc                 | xor                 ecx, esp
            //   e8????????           |                     
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   55                   | push                ebp

        $sequence_1 = { 8d45b8 50 8d4d24 e8???????? 83781408 7202 8b00 }
            // n = 7, score = 100
            //   8d45b8               | lea                 eax, [ebp - 0x48]
            //   50                   | push                eax
            //   8d4d24               | lea                 ecx, [ebp + 0x24]
            //   e8????????           |                     
            //   83781408             | cmp                 dword ptr [eax + 0x14], 8
            //   7202                 | jb                  4
            //   8b00                 | mov                 eax, dword ptr [eax]

        $sequence_2 = { 89a504ffffff c741140f000000 895910 68???????? 8819 e8???????? e8???????? }
            // n = 7, score = 100
            //   89a504ffffff         | mov                 dword ptr [ebp - 0xfc], esp
            //   c741140f000000       | mov                 dword ptr [ecx + 0x14], 0xf
            //   895910               | mov                 dword ptr [ecx + 0x10], ebx
            //   68????????           |                     
            //   8819                 | mov                 byte ptr [ecx], bl
            //   e8????????           |                     
            //   e8????????           |                     

        $sequence_3 = { 8bc8 8bdf c645fc01 e8???????? c645fc02 c70424???????? 50 }
            // n = 7, score = 100
            //   8bc8                 | mov                 ecx, eax
            //   8bdf                 | mov                 ebx, edi
            //   c645fc01             | mov                 byte ptr [ebp - 4], 1
            //   e8????????           |                     
            //   c645fc02             | mov                 byte ptr [ebp - 4], 2
            //   c70424????????       |                     
            //   50                   | push                eax

        $sequence_4 = { c645fc22 e8???????? 8bd8 8db5bcfbffff c645fc23 e8???????? 8bf8 }
            // n = 7, score = 100
            //   c645fc22             | mov                 byte ptr [ebp - 4], 0x22
            //   e8????????           |                     
            //   8bd8                 | mov                 ebx, eax
            //   8db5bcfbffff         | lea                 esi, [ebp - 0x444]
            //   c645fc23             | mov                 byte ptr [ebp - 4], 0x23
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax

        $sequence_5 = { ffb510ffffff 8d8d48ffffff e8???????? 8d9d48ffffff e8???????? 8b8510ffffff }
            // n = 6, score = 100
            //   ffb510ffffff         | push                dword ptr [ebp - 0xf0]
            //   8d8d48ffffff         | lea                 ecx, [ebp - 0xb8]
            //   e8????????           |                     
            //   8d9d48ffffff         | lea                 ebx, [ebp - 0xb8]
            //   e8????????           |                     
            //   8b8510ffffff         | mov                 eax, dword ptr [ebp - 0xf0]

        $sequence_6 = { 8bc4 89a550ffffff 50 e8???????? 8b8d5cffffff c645fc17 }
            // n = 6, score = 100
            //   8bc4                 | mov                 eax, esp
            //   89a550ffffff         | mov                 dword ptr [ebp - 0xb0], esp
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b8d5cffffff         | mov                 ecx, dword ptr [ebp - 0xa4]
            //   c645fc17             | mov                 byte ptr [ebp - 4], 0x17

        $sequence_7 = { 884597 c645fc04 e8???????? 83ec1c }
            // n = 4, score = 100
            //   884597               | mov                 byte ptr [ebp - 0x69], al
            //   c645fc04             | mov                 byte ptr [ebp - 4], 4
            //   e8????????           |                     
            //   83ec1c               | sub                 esp, 0x1c

        $sequence_8 = { ff7518 8845bc ff7514 8d45b0 ff75bc ff75d0 50 }
            // n = 7, score = 100
            //   ff7518               | push                dword ptr [ebp + 0x18]
            //   8845bc               | mov                 byte ptr [ebp - 0x44], al
            //   ff7514               | push                dword ptr [ebp + 0x14]
            //   8d45b0               | lea                 eax, [ebp - 0x50]
            //   ff75bc               | push                dword ptr [ebp - 0x44]
            //   ff75d0               | push                dword ptr [ebp - 0x30]
            //   50                   | push                eax

        $sequence_9 = { 83c40c 8d8dbcfbffff 51 8bc8 }
            // n = 4, score = 100
            //   83c40c               | add                 esp, 0xc
            //   8d8dbcfbffff         | lea                 ecx, [ebp - 0x444]
            //   51                   | push                ecx
            //   8bc8                 | mov                 ecx, eax

    condition:
        7 of them and filesize < 598016
}