rule win_rarstar_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.rarstar."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rarstar"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 89742410 33ed ff15???????? 8b542418 8b3d???????? 52 89442430 }
            // n = 7, score = 100
            //   89742410             | mov                 dword ptr [esp + 0x10], esi
            //   33ed                 | xor                 ebp, ebp
            //   ff15????????         |                     
            //   8b542418             | mov                 edx, dword ptr [esp + 0x18]
            //   8b3d????????         |                     
            //   52                   | push                edx
            //   89442430             | mov                 dword ptr [esp + 0x30], eax

        $sequence_1 = { eb26 8d4508 8db664c54000 6a00 50 ff36 }
            // n = 6, score = 100
            //   eb26                 | jmp                 0x28
            //   8d4508               | lea                 eax, [ebp + 8]
            //   8db664c54000         | lea                 esi, [esi + 0x40c564]
            //   6a00                 | push                0
            //   50                   | push                eax
            //   ff36                 | push                dword ptr [esi]

        $sequence_2 = { f7d1 2bf9 899c2430030000 8bc1 8bf7 8bfa 899c242c030000 }
            // n = 7, score = 100
            //   f7d1                 | not                 ecx
            //   2bf9                 | sub                 edi, ecx
            //   899c2430030000       | mov                 dword ptr [esp + 0x330], ebx
            //   8bc1                 | mov                 eax, ecx
            //   8bf7                 | mov                 esi, edi
            //   8bfa                 | mov                 edi, edx
            //   899c242c030000       | mov                 dword ptr [esp + 0x32c], ebx

        $sequence_3 = { 8bc6 5e c20400 81ec24030000 53 }
            // n = 5, score = 100
            //   8bc6                 | mov                 eax, esi
            //   5e                   | pop                 esi
            //   c20400               | ret                 4
            //   81ec24030000         | sub                 esp, 0x324
            //   53                   | push                ebx

        $sequence_4 = { 8b0485c0d94000 03c6 8a5004 f6c201 0f849e010000 }
            // n = 5, score = 100
            //   8b0485c0d94000       | mov                 eax, dword ptr [eax*4 + 0x40d9c0]
            //   03c6                 | add                 eax, esi
            //   8a5004               | mov                 dl, byte ptr [eax + 4]
            //   f6c201               | test                dl, 1
            //   0f849e010000         | je                  0x1a4

        $sequence_5 = { 33db 8a940c20010000 8a5c0c20 03c2 03c3 25ff000080 7907 }
            // n = 7, score = 100
            //   33db                 | xor                 ebx, ebx
            //   8a940c20010000       | mov                 dl, byte ptr [esp + ecx + 0x120]
            //   8a5c0c20             | mov                 bl, byte ptr [esp + ecx + 0x20]
            //   03c2                 | add                 eax, edx
            //   03c3                 | add                 eax, ebx
            //   25ff000080           | and                 eax, 0x800000ff
            //   7907                 | jns                 9

        $sequence_6 = { 81e200008000 52 6a00 6a00 }
            // n = 4, score = 100
            //   81e200008000         | and                 edx, 0x800000
            //   52                   | push                edx
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_7 = { 899c242c030000 899c2428030000 899c2424030000 899c2420030000 bf???????? 83c9ff }
            // n = 6, score = 100
            //   899c242c030000       | mov                 dword ptr [esp + 0x32c], ebx
            //   899c2428030000       | mov                 dword ptr [esp + 0x328], ebx
            //   899c2424030000       | mov                 dword ptr [esp + 0x324], ebx
            //   899c2420030000       | mov                 dword ptr [esp + 0x320], ebx
            //   bf????????           |                     
            //   83c9ff               | or                  ecx, 0xffffffff

        $sequence_8 = { 7405 be01000000 8b442418 57 }
            // n = 4, score = 100
            //   7405                 | je                  7
            //   be01000000           | mov                 esi, 1
            //   8b442418             | mov                 eax, dword ptr [esp + 0x18]
            //   57                   | push                edi

        $sequence_9 = { 0f8412010000 85f6 779a 8b5c241c 6a00 }
            // n = 5, score = 100
            //   0f8412010000         | je                  0x118
            //   85f6                 | test                esi, esi
            //   779a                 | ja                  0xffffff9c
            //   8b5c241c             | mov                 ebx, dword ptr [esp + 0x1c]
            //   6a00                 | push                0

    condition:
        7 of them and filesize < 122880
}