rule win_ratankba_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ratankba."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ratankba"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b17 8d0c8500000000 51 6a00 52 e8???????? 8b06 }
            // n = 7, score = 400
            //   8b17                 | mov                 edx, dword ptr [edi]
            //   8d0c8500000000       | lea                 ecx, [eax*4]
            //   51                   | push                ecx
            //   6a00                 | push                0
            //   52                   | push                edx
            //   e8????????           |                     
            //   8b06                 | mov                 eax, dword ptr [esi]

        $sequence_1 = { c745fcffffffff 899edc000000 899ee0000000 39bdd0d5ffff 720f 8b8dbcd5ffff 51 }
            // n = 7, score = 400
            //   c745fcffffffff       | mov                 dword ptr [ebp - 4], 0xffffffff
            //   899edc000000         | mov                 dword ptr [esi + 0xdc], ebx
            //   899ee0000000         | mov                 dword ptr [esi + 0xe0], ebx
            //   39bdd0d5ffff         | cmp                 dword ptr [ebp - 0x2a30], edi
            //   720f                 | jb                  0x11
            //   8b8dbcd5ffff         | mov                 ecx, dword ptr [ebp - 0x2a44]
            //   51                   | push                ecx

        $sequence_2 = { 8d8db4feffff 53 51 c785b4feffff00000000 e8???????? 8bd8 }
            // n = 6, score = 400
            //   8d8db4feffff         | lea                 ecx, [ebp - 0x14c]
            //   53                   | push                ebx
            //   51                   | push                ecx
            //   c785b4feffff00000000     | mov    dword ptr [ebp - 0x14c], 0
            //   e8????????           |                     
            //   8bd8                 | mov                 ebx, eax

        $sequence_3 = { 751b 8b45f8 3bc3 7409 50 e8???????? 83c404 }
            // n = 7, score = 400
            //   751b                 | jne                 0x1d
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   3bc3                 | cmp                 eax, ebx
            //   7409                 | je                  0xb
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4

        $sequence_4 = { 8b9510ffffff 85f6 744d 8b8ddcfeffff bb10000000 395914 7202 }
            // n = 7, score = 400
            //   8b9510ffffff         | mov                 edx, dword ptr [ebp - 0xf0]
            //   85f6                 | test                esi, esi
            //   744d                 | je                  0x4f
            //   8b8ddcfeffff         | mov                 ecx, dword ptr [ebp - 0x124]
            //   bb10000000           | mov                 ebx, 0x10
            //   395914               | cmp                 dword ptr [ecx + 0x14], ebx
            //   7202                 | jb                  4

        $sequence_5 = { 8b5304 6a18 8944ca04 e8???????? 8bf0 85f6 0f8837ffffff }
            // n = 7, score = 400
            //   8b5304               | mov                 edx, dword ptr [ebx + 4]
            //   6a18                 | push                0x18
            //   8944ca04             | mov                 dword ptr [edx + ecx*8 + 4], eax
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi
            //   0f8837ffffff         | js                  0xffffff3d

        $sequence_6 = { e8???????? 8b5004 8b45e4 8b4cd004 51 e8???????? }
            // n = 6, score = 400
            //   e8????????           |                     
            //   8b5004               | mov                 edx, dword ptr [eax + 4]
            //   8b45e4               | mov                 eax, dword ptr [ebp - 0x1c]
            //   8b4cd004             | mov                 ecx, dword ptr [eax + edx*8 + 4]
            //   51                   | push                ecx
            //   e8????????           |                     

        $sequence_7 = { 8986b8010000 8986bc010000 899eb0010000 c786b401000060ea0000 8bc6 8b4df4 }
            // n = 6, score = 400
            //   8986b8010000         | mov                 dword ptr [esi + 0x1b8], eax
            //   8986bc010000         | mov                 dword ptr [esi + 0x1bc], eax
            //   899eb0010000         | mov                 dword ptr [esi + 0x1b0], ebx
            //   c786b401000060ea0000     | mov    dword ptr [esi + 0x1b4], 0xea60
            //   8bc6                 | mov                 eax, esi
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]

        $sequence_8 = { 48 3bc7 7224 b857000780 e8???????? 8bc7 e8???????? }
            // n = 7, score = 400
            //   48                   | dec                 eax
            //   3bc7                 | cmp                 eax, edi
            //   7224                 | jb                  0x26
            //   b857000780           | mov                 eax, 0x80070057
            //   e8????????           |                     
            //   8bc7                 | mov                 eax, edi
            //   e8????????           |                     

        $sequence_9 = { 83c404 898394000000 85c0 0f847d000000 8b8d10efffff 51 }
            // n = 6, score = 400
            //   83c404               | add                 esp, 4
            //   898394000000         | mov                 dword ptr [ebx + 0x94], eax
            //   85c0                 | test                eax, eax
            //   0f847d000000         | je                  0x83
            //   8b8d10efffff         | mov                 ecx, dword ptr [ebp - 0x10f0]
            //   51                   | push                ecx

    condition:
        7 of them and filesize < 303104
}