rule win_ravenstealer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ravenstealer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ravenstealer"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4c8b742430 4883c438 415f 415c 5f 5b c3 }
            // n = 7, score = 100
            //   4c8b742430           | dec                 esp
            //   4883c438             | mov                 ecx, dword ptr [eax + 0x10]
            //   415f                 | dec                 ecx
            //   415c                 | sub                 ecx, 4
            //   5f                   | dec                 eax
            //   5b                   | lea                 ecx, [esp + 0x1ab]
            //   c3                   | dec                 eax

        $sequence_1 = { f20f5cc8 f20f59ca f20f114c2440 e8???????? 440fbef0 e8???????? 0fbed8 }
            // n = 7, score = 100
            //   f20f5cc8             | mov                 dword ptr [esp + 0x234], eax
            //   f20f59ca             | mov                 eax, dword ptr [esp + 0x30]
            //   f20f114c2440         | sub                 eax, 0x6f
            //   e8????????           |                     
            //   440fbef0             | movd                xmm2, eax
            //   e8????????           |                     
            //   0fbed8               | cvtdq2pd            xmm2, xmm2

        $sequence_2 = { c744247809000000 eb58 448d3c37 0fbe05???????? 4103c7 0fbe0d???????? 33d2 }
            // n = 7, score = 100
            //   c744247809000000     | dec                 esp
            //   eb58                 | mov                 ebp, eax
            //   448d3c37             | inc                 esp
            //   0fbe05????????       |                     
            //   4103c7               | mov                 edi, dword ptr [esp + 0x368]
            //   0fbe0d????????       |                     
            //   33d2                 | inc                 esp

        $sequence_3 = { 8b5c2450 8b742454 3bc1 0f84bb130000 0fb605???????? 0fb605???????? 0fb605???????? }
            // n = 7, score = 100
            //   8b5c2450             | inc                 ecx
            //   8b742454             | movups              xmmword ptr [edx], xmm0
            //   3bc1                 | mov                 eax, dword ptr [esp + 0x30]
            //   0f84bb130000         | cmp                 edi, eax
            //   0fb605????????       |                     
            //   0fb605????????       |                     
            //   0fb605????????       |                     

        $sequence_4 = { f20f59c8 f2440f2cf1 8b85e01f0000 83c04c f20f2ad0 0fb605???????? 0fbec8 }
            // n = 7, score = 100
            //   f20f59c8             | mulsd               xmm0, qword ptr [esp + 0x58]
            //   f2440f2cf1           | inc                 esp
            //   8b85e01f0000         | cvttps2pi           mm4, xmm0
            //   83c04c               | dec                 eax
            //   f20f2ad0             | arpl                word ptr [esp + 0x20], cx
            //   0fb605????????       |                     
            //   0fbec8               | inc                 ecx

        $sequence_5 = { f2480f2ac0 f20f594590 f20f2cc0 89442428 8b442458 83e86a 660f6ed0 }
            // n = 7, score = 100
            //   f2480f2ac0           | inc                 esp
            //   f20f594590           | and                 bl, bh
            //   f20f2cc0             | inc                 ebp
            //   89442428             | add                 bl, bl
            //   8b442458             | inc                 ecx
            //   83e86a               | movzx               edx, ch
            //   660f6ed0             | inc                 ecx

        $sequence_6 = { e8???????? 488bf8 488d9424b0000000 488d8c2450090000 e8???????? 488b18 488d9424b8000000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488bf8               | mov                 ebx, eax
            //   488d9424b0000000     | dec                 eax
            //   488d8c2450090000     | lea                 edx, [esp + 0x1c20]
            //   e8????????           |                     
            //   488b18               | dec                 eax
            //   488d9424b8000000     | lea                 ecx, [esp + 0xae8]

        $sequence_7 = { 85c0 7416 81a5fc030000fffeffff 488d8d28100000 e8???????? 4883c420 5d }
            // n = 7, score = 100
            //   85c0                 | jbe                 0x579
            //   7416                 | mov                 edx, 1
            //   81a5fc030000fffeffff     | jmp    0x57b
            //   488d8d28100000       | xor                 edx, edx
            //   e8????????           |                     
            //   4883c420             | test                eax, eax
            //   5d                   | jne                 0x651

        $sequence_8 = { 83f801 750a 488b07 488bcf ff5008 90 4d85f6 }
            // n = 7, score = 100
            //   83f801               | cvtdq2pd            xmm0, xmm0
            //   750a                 | sub                 eax, 0x32
            //   488b07               | cvtsi2sd            xmm2, eax
            //   488bcf               | movsx               ecx, al
            //   ff5008               | cvtsi2sd            xmm1, ecx
            //   90                   | movsx               ecx, al
            //   4d85f6               | sub                 eax, 0x33

        $sequence_9 = { 7406 6683f92f 7504 4883c002 483bd8 7442 0f1f8000000000 }
            // n = 7, score = 100
            //   7406                 | mov                 word ptr [esi + eax*2 + 2], dx
            //   6683f92f             | mov                 eax, dword ptr [esp + 0xa0]
            //   7504                 | inc                 eax
            //   4883c002             | mov                 dword ptr [esp + 0xa0], eax
            //   483bd8               | mov                 eax, dword ptr [esp + 0xa0]
            //   7442                 | cmp                 eax, 0x16
            //   0f1f8000000000       | jb                  0xfffffce8

    condition:
        7 of them and filesize < 8337408
}