rule win_rc2fm_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.rc2fm."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rc2fm"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4885c0 7431 8b542420 488b4c2428 4533c0 e8???????? 448b442420 }
            // n = 7, score = 100
            //   4885c0               | mov                 ecx, dword ptr [ebx + 0x50]
            //   7431                 | dec                 esp
            //   8b542420             | add                 ecx, eax
            //   488b4c2428           | dec                 ecx
            //   4533c0               | lea                 eax, [ecx - 1]
            //   e8????????           |                     
            //   448b442420           | movzx               edx, byte ptr [eax]

        $sequence_1 = { 8bc1 d1e9 83e001 418b0481 33c1 3305???????? 33d2 }
            // n = 7, score = 100
            //   8bc1                 | mov                 ecx, dword ptr [esp + 0x68]
            //   d1e9                 | dec                 eax
            //   83e001               | mov                 eax, dword ptr [ecx]
            //   418b0481             | call                dword ptr [eax + 0x10]
            //   33c1                 | jmp                 0xf22
            //   3305????????         |                     
            //   33d2                 | inc                 esp

        $sequence_2 = { 48c1e004 4c89642430 4803c1 4889442438 }
            // n = 4, score = 100
            //   48c1e004             | mov                 dword ptr [esp + 0x90], ebp
            //   4c89642430           | dec                 eax
            //   4803c1               | mov                 dword ptr [esp + 0x48], edi
            //   4889442438           | inc                 ebp

        $sequence_3 = { 33d2 ff15???????? 488b0d???????? ff15???????? e9???????? 40b70d e9???????? }
            // n = 7, score = 100
            //   33d2                 | cmp                 ecx, esi
            //   ff15????????         |                     
            //   488b0d????????       |                     
            //   ff15????????         |                     
            //   e9????????           |                     
            //   40b70d               | jae                 0xb43
            //   e9????????           |                     

        $sequence_4 = { 0f8736080000 4883791000 0f842b080000 48833900 750a 83790800 0f851b080000 }
            // n = 7, score = 100
            //   0f8736080000         | mov                 eax, esi
            //   4883791000           | xor                 edx, edx
            //   0f842b080000         | dec                 esp
            //   48833900             | mov                 eax, dword ptr [ebp - 0x70]
            //   750a                 | dec                 ebp
            //   83790800             | mov                 eax, esi
            //   0f851b080000         | xor                 edx, edx

        $sequence_5 = { 41b804000000 488bc8 4889742470 4032ed 48c744242000000000 ff15???????? 85c0 }
            // n = 7, score = 100
            //   41b804000000         | dec                 eax
            //   488bc8               | sub                 ecx, ebp
            //   4889742470           | mov                 byte ptr [eax + 4], cl
            //   4032ed               | dec                 eax
            //   48c744242000000000     | mov    dword ptr [esp + 0x138], ecx
            //   ff15????????         |                     
            //   85c0                 | movzx               ecx, byte ptr [esp + 0x139]

        $sequence_6 = { ff5010 eb62 448bc0 ba03000700 b900000100 e8???????? }
            // n = 6, score = 100
            //   ff5010               | push                edi
            //   eb62                 | dec                 eax
            //   448bc0               | sub                 esp, 0xe0
            //   ba03000700           | dec                 ecx
            //   b900000100           | mov                 esi, eax
            //   e8????????           |                     

        $sequence_7 = { ff90a8000000 85c0 792c 448bc0 ba07000a00 b903000100 e8???????? }
            // n = 7, score = 100
            //   ff90a8000000         | je                  0x228
            //   85c0                 | mov                 edx, 0x50013
            //   792c                 | dec                 eax
            //   448bc0               | mov                 ecx, dword ptr [esp + 0x40]
            //   ba07000a00           | dec                 eax
            //   b903000100           | cmp                 eax, dword ptr [ecx + 0x18]
            //   e8????????           |                     

        $sequence_8 = { 5e c3 ff15???????? ba06000600 b911000100 448bc0 e8???????? }
            // n = 7, score = 100
            //   5e                   | dec                 eax
            //   c3                   | test                eax, eax
            //   ff15????????         |                     
            //   ba06000600           | je                  0x8ef
            //   b911000100           | mov                 edx, 8
            //   448bc0               | mov                 edi, eax
            //   e8????????           |                     

        $sequence_9 = { 0f8781010000 83fd09 0f8778010000 448b642478 4183fc04 0f8769010000 488b4938 }
            // n = 7, score = 100
            //   0f8781010000         | dec                 esp
            //   83fd09               | mov                 esp, dword ptr [esp + 0xb8]
            //   0f8778010000         | inc                 eax
            //   448b642478           | movzx               eax, ch
            //   4183fc04             | dec                 ebp
            //   0f8769010000         | mov                 eax, edi
            //   488b4938             | xor                 edx, edx

    condition:
        7 of them and filesize < 410624
}