rule win_rcs_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.rcs."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rcs"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 83c430 6aff 68???????? }
            // n = 4, score = 200
            //   e8????????           |                     
            //   83c430               | add                 esp, 0x30
            //   6aff                 | push                -1
            //   68????????           |                     

        $sequence_1 = { 89442456 8944245a 8944245e 89442462 89442466 8944246a }
            // n = 6, score = 200
            //   89442456             | mov                 dword ptr [esp + 0x56], eax
            //   8944245a             | mov                 dword ptr [esp + 0x5a], eax
            //   8944245e             | mov                 dword ptr [esp + 0x5e], eax
            //   89442462             | mov                 dword ptr [esp + 0x62], eax
            //   89442466             | mov                 dword ptr [esp + 0x66], eax
            //   8944246a             | mov                 dword ptr [esp + 0x6a], eax

        $sequence_2 = { ff15???????? 5f 5e 5d 5b 33c0 }
            // n = 6, score = 200
            //   ff15????????         |                     
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   5b                   | pop                 ebx
            //   33c0                 | xor                 eax, eax

        $sequence_3 = { 85ff 0f84d4000000 57 e8???????? }
            // n = 4, score = 200
            //   85ff                 | test                edi, edi
            //   0f84d4000000         | je                  0xda
            //   57                   | push                edi
            //   e8????????           |                     

        $sequence_4 = { 40 68???????? 50 e8???????? 83c40c eb0d }
            // n = 6, score = 200
            //   40                   | inc                 eax
            //   68????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   eb0d                 | jmp                 0xf

        $sequence_5 = { 6a00 6880000000 6a01 6a00 6a05 }
            // n = 5, score = 200
            //   6a00                 | push                0
            //   6880000000           | push                0x80
            //   6a01                 | push                1
            //   6a00                 | push                0
            //   6a05                 | push                5

        $sequence_6 = { 83fd03 7c89 8b7c243c 33ed }
            // n = 4, score = 100
            //   83fd03               | cmp                 ebp, 3
            //   7c89                 | jl                  0xffffff8b
            //   8b7c243c             | mov                 edi, dword ptr [esp + 0x3c]
            //   33ed                 | xor                 ebp, ebp

        $sequence_7 = { 6a20 6a01 6a0a 6a11 ff5660 8bbedc000000 }
            // n = 6, score = 100
            //   6a20                 | push                0x20
            //   6a01                 | push                1
            //   6a0a                 | push                0xa
            //   6a11                 | push                0x11
            //   ff5660               | call                dword ptr [esi + 0x60]
            //   8bbedc000000         | mov                 edi, dword ptr [esi + 0xdc]

        $sequence_8 = { 8bbedc000000 8bbf14120000 89da 81e2ffff0000 c1e204 }
            // n = 5, score = 100
            //   8bbedc000000         | mov                 edi, dword ptr [esi + 0xdc]
            //   8bbf14120000         | mov                 edi, dword ptr [edi + 0x1214]
            //   89da                 | mov                 edx, ebx
            //   81e2ffff0000         | and                 edx, 0xffff
            //   c1e204               | shl                 edx, 4

        $sequence_9 = { 89473c 8b7d08 8b37 81c6a1010000 }
            // n = 4, score = 100
            //   89473c               | mov                 dword ptr [edi + 0x3c], eax
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   8b37                 | mov                 esi, dword ptr [edi]
            //   81c6a1010000         | add                 esi, 0x1a1

        $sequence_10 = { e8???????? 83c41c 8d4d80 83c8ff }
            // n = 4, score = 100
            //   e8????????           |                     
            //   83c41c               | add                 esp, 0x1c
            //   8d4d80               | lea                 ecx, [ebp - 0x80]
            //   83c8ff               | or                  eax, 0xffffffff

        $sequence_11 = { c9 c3 55 89e5 81ec04020000 }
            // n = 5, score = 100
            //   c9                   | leave               
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   89e5                 | mov                 ebp, esp
            //   81ec04020000         | sub                 esp, 0x204

        $sequence_12 = { 81f2be387d15 e9???????? 8be5 c1cead }
            // n = 4, score = 100
            //   81f2be387d15         | xor                 edx, 0x157d38be
            //   e9????????           |                     
            //   8be5                 | mov                 esp, ebp
            //   c1cead               | ror                 esi, 0xad

        $sequence_13 = { 83fd02 7c2d 8b07 8d54300c 3b11 7350 03c6 }
            // n = 7, score = 100
            //   83fd02               | cmp                 ebp, 2
            //   7c2d                 | jl                  0x2f
            //   8b07                 | mov                 eax, dword ptr [edi]
            //   8d54300c             | lea                 edx, [eax + esi + 0xc]
            //   3b11                 | cmp                 edx, dword ptr [ecx]
            //   7350                 | jae                 0x52
            //   03c6                 | add                 eax, esi

        $sequence_14 = { 898528f4fbff 8b86dc000000 833800 0f94c0 83e001 }
            // n = 5, score = 100
            //   898528f4fbff         | mov                 dword ptr [ebp - 0x40bd8], eax
            //   8b86dc000000         | mov                 eax, dword ptr [esi + 0xdc]
            //   833800               | cmp                 dword ptr [eax], 0
            //   0f94c0               | sete                al
            //   83e001               | and                 eax, 1

        $sequence_15 = { 81f2d141ed35 f8 f5 d1ca }
            // n = 4, score = 100
            //   81f2d141ed35         | xor                 edx, 0x35ed41d1
            //   f8                   | clc                 
            //   f5                   | cmc                 
            //   d1ca                 | ror                 edx, 1

        $sequence_16 = { 817deca4000000 72c2 56 e8???????? }
            // n = 4, score = 100
            //   817deca4000000       | cmp                 dword ptr [ebp - 0x14], 0xa4
            //   72c2                 | jb                  0xffffffc4
            //   56                   | push                esi
            //   e8????????           |                     

        $sequence_17 = { ffb56cf4fbff ffb584f4fbff ffb5a0f9fbff 8b86dc000000 8b5020 03905c020000 52 }
            // n = 7, score = 100
            //   ffb56cf4fbff         | push                dword ptr [ebp - 0x40b94]
            //   ffb584f4fbff         | push                dword ptr [ebp - 0x40b7c]
            //   ffb5a0f9fbff         | push                dword ptr [ebp - 0x40660]
            //   8b86dc000000         | mov                 eax, dword ptr [esi + 0xdc]
            //   8b5020               | mov                 edx, dword ptr [eax + 0x20]
            //   03905c020000         | add                 edx, dword ptr [eax + 0x25c]
            //   52                   | push                edx

    condition:
        7 of them and filesize < 11501568
}