rule win_recordbreaker_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.recordbreaker."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.recordbreaker"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 8b15???????? 8bc8 e8???????? 8b55f0 }
            // n = 5, score = 700
            //   e8????????           |                     
            //   8b15????????         |                     
            //   8bc8                 | mov                 ecx, eax
            //   e8????????           |                     
            //   8b55f0               | mov                 edx, dword ptr [ebp - 0x10]

        $sequence_1 = { 8a040e 46 8802 42 3bf3 72f5 }
            // n = 6, score = 700
            //   8a040e               | mov                 al, byte ptr [esi + ecx]
            //   46                   | inc                 esi
            //   8802                 | mov                 byte ptr [edx], al
            //   42                   | inc                 edx
            //   3bf3                 | cmp                 esi, ebx
            //   72f5                 | jb                  0xfffffff7

        $sequence_2 = { 51 8d4de4 51 ff750c a5 }
            // n = 5, score = 700
            //   51                   | push                ecx
            //   8d4de4               | lea                 ecx, [ebp - 0x1c]
            //   51                   | push                ecx
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]

        $sequence_3 = { ff15???????? 33c0 40 eb08 ff15???????? 33c0 5f }
            // n = 7, score = 700
            //   ff15????????         |                     
            //   33c0                 | xor                 eax, eax
            //   40                   | inc                 eax
            //   eb08                 | jmp                 0xa
            //   ff15????????         |                     
            //   33c0                 | xor                 eax, eax
            //   5f                   | pop                 edi

        $sequence_4 = { 8365f800 a1???????? c745f464000000 53 56 }
            // n = 5, score = 700
            //   8365f800             | and                 dword ptr [ebp - 8], 0
            //   a1????????           |                     
            //   c745f464000000       | mov                 dword ptr [ebp - 0xc], 0x64
            //   53                   | push                ebx
            //   56                   | push                esi

        $sequence_5 = { 33c0 50 6800000008 6a02 50 50 }
            // n = 6, score = 700
            //   33c0                 | xor                 eax, eax
            //   50                   | push                eax
            //   6800000008           | push                0x8000000
            //   6a02                 | push                2
            //   50                   | push                eax
            //   50                   | push                eax

        $sequence_6 = { ba04010000 8d0c41 51 8d85d0fdffff 50 }
            // n = 5, score = 700
            //   ba04010000           | mov                 edx, 0x104
            //   8d0c41               | lea                 ecx, [ecx + eax*2]
            //   51                   | push                ecx
            //   8d85d0fdffff         | lea                 eax, [ebp - 0x230]
            //   50                   | push                eax

        $sequence_7 = { ff15???????? 8b7508 83c410 8bd3 }
            // n = 4, score = 700
            //   ff15????????         |                     
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   83c410               | add                 esp, 0x10
            //   8bd3                 | mov                 edx, ebx

        $sequence_8 = { 8b15???????? 8bc8 e8???????? 8b55f8 }
            // n = 4, score = 700
            //   8b15????????         |                     
            //   8bc8                 | mov                 ecx, eax
            //   e8????????           |                     
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]

        $sequence_9 = { 81ec68040000 837d1002 53 56 8bf2 57 }
            // n = 6, score = 700
            //   81ec68040000         | sub                 esp, 0x468
            //   837d1002             | cmp                 dword ptr [ebp + 0x10], 2
            //   53                   | push                ebx
            //   56                   | push                esi
            //   8bf2                 | mov                 esi, edx
            //   57                   | push                edi

    condition:
        7 of them and filesize < 232312
}