rule win_red_gambler_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.red_gambler."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.red_gambler"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6800010000 8d440601 50 68???????? e9???????? 68???????? }
            // n = 6, score = 400
            //   6800010000           | push                0x100
            //   8d440601             | lea                 eax, [esi + eax + 1]
            //   50                   | push                eax
            //   68????????           |                     
            //   e9????????           |                     
            //   68????????           |                     

        $sequence_1 = { 55 8bec 837d0c10 56 57 }
            // n = 5, score = 400
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   837d0c10             | cmp                 dword ptr [ebp + 0xc], 0x10
            //   56                   | push                esi
            //   57                   | push                edi

        $sequence_2 = { 8d55fc 52 56 6a00 6880000000 6a02 ffd7 }
            // n = 7, score = 400
            //   8d55fc               | lea                 edx, [ebp - 4]
            //   52                   | push                edx
            //   56                   | push                esi
            //   6a00                 | push                0
            //   6880000000           | push                0x80
            //   6a02                 | push                2
            //   ffd7                 | call                edi

        $sequence_3 = { 33db 68ff000000 8d44244d 53 }
            // n = 4, score = 400
            //   33db                 | xor                 ebx, ebx
            //   68ff000000           | push                0xff
            //   8d44244d             | lea                 eax, [esp + 0x4d]
            //   53                   | push                ebx

        $sequence_4 = { 8b1d???????? 8da42400000000 6a00 68???????? ffd3 }
            // n = 5, score = 400
            //   8b1d????????         |                     
            //   8da42400000000       | lea                 esp, [esp]
            //   6a00                 | push                0
            //   68????????           |                     
            //   ffd3                 | call                ebx

        $sequence_5 = { ff15???????? 85c0 7520 8b542418 52 8d84243c010000 }
            // n = 6, score = 400
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7520                 | jne                 0x22
            //   8b542418             | mov                 edx, dword ptr [esp + 0x18]
            //   52                   | push                edx
            //   8d84243c010000       | lea                 eax, [esp + 0x13c]

        $sequence_6 = { 33c8 03ff 03ff 83e1f0 }
            // n = 4, score = 400
            //   33c8                 | xor                 ecx, eax
            //   03ff                 | add                 edi, edi
            //   03ff                 | add                 edi, edi
            //   83e1f0               | and                 ecx, 0xfffffff0

        $sequence_7 = { 90 57 8d95fcfeffff 52 }
            // n = 4, score = 400
            //   90                   | nop                 
            //   57                   | push                edi
            //   8d95fcfeffff         | lea                 edx, [ebp - 0x104]
            //   52                   | push                edx

        $sequence_8 = { 52 ff15???????? 8d8594fbffff 50 }
            // n = 4, score = 300
            //   52                   | push                edx
            //   ff15????????         |                     
            //   8d8594fbffff         | lea                 eax, [ebp - 0x46c]
            //   50                   | push                eax

        $sequence_9 = { 7f6f c8603a0c 7364 42 e5e1 5f }
            // n = 6, score = 300
            //   7f6f                 | jg                  0x71
            //   c8603a0c             | enter               0x3a60, 0xc
            //   7364                 | jae                 0x66
            //   42                   | inc                 edx
            //   e5e1                 | in                  eax, 0xe1
            //   5f                   | pop                 edi

        $sequence_10 = { 3d067c263c 3c3d 9e e7bd }
            // n = 4, score = 300
            //   3d067c263c           | cmp                 eax, 0x3c267c06
            //   3c3d                 | cmp                 al, 0x3d
            //   9e                   | sahf                
            //   e7bd                 | out                 0xbd, eax

        $sequence_11 = { 6800010000 8d8dfcfdffff 51 6a00 }
            // n = 4, score = 300
            //   6800010000           | push                0x100
            //   8d8dfcfdffff         | lea                 ecx, [ebp - 0x204]
            //   51                   | push                ecx
            //   6a00                 | push                0

        $sequence_12 = { 64f33c87 3cfb 3ccd 047e 0000 3e2a6616 2bb0775ea707 }
            // n = 7, score = 300
            //   64f33c87             | cmp                 al, 0x87
            //   3cfb                 | cmp                 al, 0xfb
            //   3ccd                 | cmp                 al, 0xcd
            //   047e                 | add                 al, 0x7e
            //   0000                 | add                 byte ptr [eax], al
            //   3e2a6616             | sub                 ah, byte ptr ds:[esi + 0x16]
            //   2bb0775ea707         | sub                 esi, dword ptr [eax + 0x7a75e77]

        $sequence_13 = { ff15???????? 83c414 6a00 6a00 8d9598fbffff }
            // n = 5, score = 300
            //   ff15????????         |                     
            //   83c414               | add                 esp, 0x14
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   8d9598fbffff         | lea                 edx, [ebp - 0x468]

        $sequence_14 = { 8d8594fbffff 50 8d4d98 51 ff15???????? }
            // n = 5, score = 300
            //   8d8594fbffff         | lea                 eax, [ebp - 0x46c]
            //   50                   | push                eax
            //   8d4d98               | lea                 ecx, [ebp - 0x68]
            //   51                   | push                ecx
            //   ff15????????         |                     

        $sequence_15 = { 2bb0775ea707 2d9e2b3706 d7 e8???????? 004f21 7ea2 }
            // n = 6, score = 300
            //   2bb0775ea707         | sub                 esi, dword ptr [eax + 0x7a75e77]
            //   2d9e2b3706           | sub                 eax, 0x6372b9e
            //   d7                   | xlatb               
            //   e8????????           |                     
            //   004f21               | add                 byte ptr [edi + 0x21], cl
            //   7ea2                 | jle                 0xffffffa4

        $sequence_16 = { 6800010000 8d85fcfeffff 50 6a00 ff15???????? }
            // n = 5, score = 300
            //   6800010000           | push                0x100
            //   8d85fcfeffff         | lea                 eax, [ebp - 0x104]
            //   50                   | push                eax
            //   6a00                 | push                0
            //   ff15????????         |                     

        $sequence_17 = { 68???????? 8d8d98fbffff 68???????? 51 }
            // n = 4, score = 300
            //   68????????           |                     
            //   8d8d98fbffff         | lea                 ecx, [ebp - 0x468]
            //   68????????           |                     
            //   51                   | push                ecx

        $sequence_18 = { 8d9598fbffff 52 68???????? 6a00 6a00 ff15???????? 8b4dfc }
            // n = 7, score = 300
            //   8d9598fbffff         | lea                 edx, [ebp - 0x468]
            //   52                   | push                edx
            //   68????????           |                     
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]

        $sequence_19 = { 2b2a bee7eee947 7c26 0e 6706 7e0e 2829 }
            // n = 7, score = 300
            //   2b2a                 | sub                 ebp, dword ptr [edx]
            //   bee7eee947           | mov                 esi, 0x47e9eee7
            //   7c26                 | jl                  0x28
            //   0e                   | push                cs
            //   6706                 | push                es
            //   7e0e                 | jle                 0x10
            //   2829                 | sub                 byte ptr [ecx], ch

        $sequence_20 = { 8d5598 52 8d8598fdffff 50 68???????? 8d8d98fbffff }
            // n = 6, score = 300
            //   8d5598               | lea                 edx, [ebp - 0x68]
            //   52                   | push                edx
            //   8d8598fdffff         | lea                 eax, [ebp - 0x268]
            //   50                   | push                eax
            //   68????????           |                     
            //   8d8d98fbffff         | lea                 ecx, [ebp - 0x468]

        $sequence_21 = { 6800010000 8d8d98fdffff 51 8d9598feffff }
            // n = 4, score = 300
            //   6800010000           | push                0x100
            //   8d8d98fdffff         | lea                 ecx, [ebp - 0x268]
            //   51                   | push                ecx
            //   8d9598feffff         | lea                 edx, [ebp - 0x168]

        $sequence_22 = { 74be 6f 665b e17a 6c 8737 27 }
            // n = 7, score = 300
            //   74be                 | je                  0xffffffc0
            //   6f                   | outsd               dx, dword ptr [esi]
            //   665b                 | pop                 bx
            //   e17a                 | loope               0x7c
            //   6c                   | insb                byte ptr es:[edi], dx
            //   8737                 | xchg                dword ptr [edi], esi
            //   27                   | daa                 

        $sequence_23 = { 4c 48 44 40 }
            // n = 4, score = 300
            //   4c                   | dec                 esp
            //   48                   | dec                 eax
            //   44                   | inc                 esp
            //   40                   | inc                 eax

        $sequence_24 = { 6e 44 b11a dfaf4e71ac05 }
            // n = 4, score = 300
            //   6e                   | outsb               dx, byte ptr [esi]
            //   44                   | inc                 esp
            //   b11a                 | mov                 cl, 0x1a
            //   dfaf4e71ac05         | fild                qword ptr [edi + 0x5ac714e]

        $sequence_25 = { ff96bcd60000 83c704 8d5efc 31c0 }
            // n = 4, score = 100
            //   ff96bcd60000         | call                dword ptr [esi + 0xd6bc]
            //   83c704               | add                 edi, 4
            //   8d5efc               | lea                 ebx, [esi - 4]
            //   31c0                 | xor                 eax, eax

        $sequence_26 = { ffd3 68???????? 56 8bf8 ffd3 8bd8 ffd7 }
            // n = 7, score = 100
            //   ffd3                 | call                ebx
            //   68????????           |                     
            //   56                   | push                esi
            //   8bf8                 | mov                 edi, eax
            //   ffd3                 | call                ebx
            //   8bd8                 | mov                 ebx, eax
            //   ffd7                 | call                edi

        $sequence_27 = { ff15???????? 40 68???????? 50 ff15???????? 8d8dfcfeffff }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   40                   | inc                 eax
            //   68????????           |                     
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8d8dfcfeffff         | lea                 ecx, [ebp - 0x104]

        $sequence_28 = { a1???????? a3???????? a1???????? c705????????6b214000 8935???????? a3???????? }
            // n = 6, score = 100
            //   a1????????           |                     
            //   a3????????           |                     
            //   a1????????           |                     
            //   c705????????6b214000     |     
            //   8935????????         |                     
            //   a3????????           |                     

        $sequence_29 = { c1f805 c1e606 033485c0974000 8b45f8 }
            // n = 4, score = 100
            //   c1f805               | sar                 eax, 5
            //   c1e606               | shl                 esi, 6
            //   033485c0974000       | add                 esi, dword ptr [eax*4 + 0x4097c0]
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]

        $sequence_30 = { 85f6 0f8492000000 8b1d???????? 68???????? }
            // n = 4, score = 100
            //   85f6                 | test                esi, esi
            //   0f8492000000         | je                  0x98
            //   8b1d????????         |                     
            //   68????????           |                     

        $sequence_31 = { f2ae 55 ff96acd60000 09c0 7407 8903 83c304 }
            // n = 7, score = 100
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   55                   | push                ebp
            //   ff96acd60000         | call                dword ptr [esi + 0xd6ac]
            //   09c0                 | or                  eax, eax
            //   7407                 | je                  9
            //   8903                 | mov                 dword ptr [ebx], eax
            //   83c304               | add                 ebx, 4

    condition:
        7 of them and filesize < 327680
}