rule win_redalpha_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.redalpha."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.redalpha"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c40c c0e304 0fb6c3 50 68???????? }
            // n = 5, score = 400
            //   83c40c               | add                 esp, 0xc
            //   c0e304               | shl                 bl, 4
            //   0fb6c3               | movzx               eax, bl
            //   50                   | push                eax
            //   68????????           |                     

        $sequence_1 = { 68???????? 50 e8???????? 83c40c c0e304 }
            // n = 5, score = 400
            //   68????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   c0e304               | shl                 bl, 4

        $sequence_2 = { 8b4314 015330 ffd0 5f }
            // n = 4, score = 300
            //   8b4314               | add                 esi, edx
            //   015330               | mov                 eax, dword ptr [ebx + 0xc]
            //   ffd0                 | call                eax
            //   5f                   | lea                 edx, [eax - 1]

        $sequence_3 = { 8b4310 ffd0 8945fc 85c0 }
            // n = 4, score = 300
            //   8b4310               | add                 esp, 0xc
            //   ffd0                 | shl                 bl, 4
            //   8945fc               | movzx               eax, bl
            //   85c0                 | push                eax

        $sequence_4 = { 488da998000000 458be0 4c8be9 488bfa 488d4d20 ff15???????? 488b4508 }
            // n = 7, score = 300
            //   488da998000000       | inc                 eax
            //   458be0               | movzx               edx, bh
            //   4c8be9               | test                dl, 0x10
            //   488bfa               | jne                 0x46
            //   488d4d20             | nop                 dword ptr [eax + eax]
            //   ff15????????         |                     
            //   488b4508             | dec                 eax

        $sequence_5 = { 8785c8000000 488b8dd8000000 ff15???????? 488b8de0000000 ff15???????? 48c785d8000000ffffffff }
            // n = 6, score = 300
            //   8785c8000000         | dec                 ecx
            //   488b8dd8000000       | mov                 ebx, dword ptr [esi]
            //   ff15????????         |                     
            //   488b8de0000000       | mov                 dword ptr [ebx + ecx*4], eax
            //   ff15????????         |                     
            //   48c785d8000000ffffffff     | dec    eax

        $sequence_6 = { 8b4328 8bcb 52 8b5310 }
            // n = 4, score = 300
            //   8b4328               | mov                 dword ptr [edi], 0xffffffff
            //   8bcb                 | mov                 eax, dword ptr [ebx + 0x24]
            //   52                   | mov                 dword ptr [ebp - 8], esi
            //   8b5310               | mov                 dword ptr [ebp - 0x24], eax

        $sequence_7 = { 89048b 488b4d58 418bc5 48c1e002 480101 }
            // n = 5, score = 300
            //   89048b               | mov                 dword ptr [ebp - 0x60], edi
            //   488b4d58             | inc                 ecx
            //   418bc5               | mov                 esp, 0x13
            //   48c1e002             | dec                 eax
            //   480101               | mov                 dword ptr [ebp - 0x58], edi

        $sequence_8 = { eb0e 48897da0 41bc13000000 48897da8 498b1e }
            // n = 5, score = 300
            //   eb0e                 | xor                 ecx, ecx
            //   48897da0             | inc                 ebp
            //   41bc13000000         | xor                 eax, eax
            //   48897da8             | jmp                 0x10
            //   498b1e               | dec                 eax

        $sequence_9 = { d3eb 442bd9 400fb6d7 f6c210 753d 0f1f840000000000 }
            // n = 6, score = 300
            //   d3eb                 | mov                 ecx, dword ptr [ebp + 0x58]
            //   442bd9               | inc                 ecx
            //   400fb6d7             | mov                 eax, ebp
            //   f6c210               | dec                 eax
            //   753d                 | shl                 eax, 2
            //   0f1f840000000000     | dec                 eax

        $sequence_10 = { 8b430c ffd0 8d50ff 8b45fc 03f2 }
            // n = 5, score = 300
            //   8b430c               | movzx               eax, bl
            //   ffd0                 | push                eax
            //   8d50ff               | push                eax
            //   8b45fc               | add                 esp, 0xc
            //   03f2                 | shl                 bl, 4

        $sequence_11 = { e9???????? 488d5908 488d4b20 ff15???????? 488b4308 48894310 ba00040000 }
            // n = 7, score = 300
            //   e9????????           |                     
            //   488d5908             | add                 dword ptr [ecx], eax
            //   488d4b20             | xchg                dword ptr [ebp + 0xc8], eax
            //   ff15????????         |                     
            //   488b4308             | dec                 eax
            //   48894310             | mov                 ecx, dword ptr [ebp + 0xd8]
            //   ba00040000           | dec                 eax

        $sequence_12 = { 8b4328 52 8b5310 2b5604 }
            // n = 4, score = 300
            //   8b4328               | mov                 eax, esi
            //   52                   | mov                 eax, dword ptr [ebx + 0x14]
            //   8b5310               | add                 dword ptr [ebx + 0x30], edx
            //   2b5604               | call                eax

        $sequence_13 = { 8b4324 8975f8 8945dc 8b4328 }
            // n = 4, score = 300
            //   8b4324               | je                  0x5c
            //   8975f8               | mov                 eax, dword ptr [ebx + 0x10]
            //   8945dc               | call                eax
            //   8b4328               | mov                 dword ptr [ebp - 4], eax

        $sequence_14 = { 48897db8 448865c0 4533c9 4533c0 33d2 33c9 }
            // n = 6, score = 300
            //   48897db8             | mov                 ecx, dword ptr [ebp + 0xe0]
            //   448865c0             | dec                 eax
            //   4533c9               | mov                 dword ptr [ebp + 0xd8], 0xffffffff
            //   4533c0               | shr                 ebx, cl
            //   33d2                 | inc                 esp
            //   33c9                 | sub                 ebx, ecx

        $sequence_15 = { e8???????? 48c744243000000000 c744242880000000 c744242002000000 4533c9 4533c0 }
            // n = 6, score = 300
            //   e8????????           |                     
            //   48c744243000000000     | dec    eax
            //   c744242880000000     | mov                 dword ptr [esp + 0x30], 0
            //   c744242002000000     | mov                 dword ptr [esp + 0x28], 0x80
            //   4533c9               | mov                 dword ptr [esp + 0x20], 2
            //   4533c0               | inc                 ebp

        $sequence_16 = { 89441f05 8b85c0feffff 89441f09 8b85c4feffff }
            // n = 4, score = 100
            //   89441f05             | mov                 dword ptr [edi + ebx + 5], eax
            //   8b85c0feffff         | mov                 eax, dword ptr [ebp - 0x140]
            //   89441f09             | mov                 dword ptr [edi + ebx + 9], eax
            //   8b85c4feffff         | mov                 eax, dword ptr [ebp - 0x13c]

        $sequence_17 = { 6a00 6a00 8d8534ffffff c78514feffff08b94000 898518feffff 8d8514feffff }
            // n = 6, score = 100
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   8d8534ffffff         | lea                 eax, [ebp - 0xcc]
            //   c78514feffff08b94000     | mov    dword ptr [ebp - 0x1ec], 0x40b908
            //   898518feffff         | mov                 dword ptr [ebp - 0x1e8], eax
            //   8d8514feffff         | lea                 eax, [ebp - 0x1ec]

        $sequence_18 = { e8???????? 8b404c 83b8a800000000 7512 8b04bd30744100 807c302900 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   8b404c               | mov                 eax, dword ptr [eax + 0x4c]
            //   83b8a800000000       | cmp                 dword ptr [eax + 0xa8], 0
            //   7512                 | jne                 0x14
            //   8b04bd30744100       | mov                 eax, dword ptr [edi*4 + 0x417430]
            //   807c302900           | cmp                 byte ptr [eax + esi + 0x29], 0

        $sequence_19 = { 660fd60f 8d7f08 8b048d343b4000 ffe0 }
            // n = 4, score = 100
            //   660fd60f             | movq                qword ptr [edi], xmm1
            //   8d7f08               | lea                 edi, [edi + 8]
            //   8b048d343b4000       | mov                 eax, dword ptr [ecx*4 + 0x403b34]
            //   ffe0                 | jmp                 eax

        $sequence_20 = { 8bec 81ec1c010000 56 6880000000 8bf1 c745f8ff000000 6a00 }
            // n = 7, score = 100
            //   8bec                 | mov                 ebp, esp
            //   81ec1c010000         | sub                 esp, 0x11c
            //   56                   | push                esi
            //   6880000000           | push                0x80
            //   8bf1                 | mov                 esi, ecx
            //   c745f8ff000000       | mov                 dword ptr [ebp - 8], 0xff
            //   6a00                 | push                0

        $sequence_21 = { 8d44241c 50 8d442424 50 8d442418 }
            // n = 5, score = 100
            //   8d44241c             | lea                 eax, [esp + 0x1c]
            //   50                   | push                eax
            //   8d442424             | lea                 eax, [esp + 0x24]
            //   50                   | push                eax
            //   8d442418             | lea                 eax, [esp + 0x18]

        $sequence_22 = { 8d45f4 8bcf 50 e8???????? 5f 5e 5b }
            // n = 7, score = 100
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   8bcf                 | mov                 ecx, edi
            //   50                   | push                eax
            //   e8????????           |                     
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx

        $sequence_23 = { 6a34 68???????? 57 ff15???????? 8bf0 85f6 7517 }
            // n = 7, score = 100
            //   6a34                 | push                0x34
            //   68????????           |                     
            //   57                   | push                edi
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi
            //   7517                 | jne                 0x19

        $sequence_24 = { ff15???????? 8bf8 85ff 7459 6a00 }
            // n = 5, score = 100
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax
            //   85ff                 | test                edi, edi
            //   7459                 | je                  0x5b
            //   6a00                 | push                0

        $sequence_25 = { c745dc03000000 eb7c c745e040314100 ebbb d9e8 8b4510 dd18 }
            // n = 7, score = 100
            //   c745dc03000000       | mov                 dword ptr [ebp - 0x24], 3
            //   eb7c                 | jmp                 0x7e
            //   c745e040314100       | mov                 dword ptr [ebp - 0x20], 0x413140
            //   ebbb                 | jmp                 0xffffffbd
            //   d9e8                 | fld1                
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   dd18                 | fstp                qword ptr [eax]

        $sequence_26 = { 8b4710 8d044502000000 50 7219 }
            // n = 4, score = 100
            //   8b4710               | mov                 eax, dword ptr [edi + 0x10]
            //   8d044502000000       | lea                 eax, [eax*2 + 2]
            //   50                   | push                eax
            //   7219                 | jb                  0x1b

        $sequence_27 = { 50 f3a5 8d8574ffffff 8bca }
            // n = 4, score = 100
            //   50                   | push                eax
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   8d8574ffffff         | lea                 eax, [ebp - 0x8c]
            //   8bca                 | mov                 ecx, edx

        $sequence_28 = { c1fa06 8934b8 8bc7 83e03f 6bc830 8b0495581f4000 8b440818 }
            // n = 7, score = 100
            //   c1fa06               | sar                 edx, 6
            //   8934b8               | mov                 dword ptr [eax + edi*4], esi
            //   8bc7                 | mov                 eax, edi
            //   83e03f               | and                 eax, 0x3f
            //   6bc830               | imul                ecx, eax, 0x30
            //   8b0495581f4000       | mov                 eax, dword ptr [edx*4 + 0x401f58]
            //   8b440818             | mov                 eax, dword ptr [eax + ecx + 0x18]

        $sequence_29 = { 7517 57 ff15???????? 5e 5f 8b4dfc }
            // n = 6, score = 100
            //   7517                 | jne                 0x19
            //   57                   | push                edi
            //   ff15????????         |                     
            //   5e                   | pop                 esi
            //   5f                   | pop                 edi
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]

    condition:
        7 of them and filesize < 606208
}