rule win_redcurl_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.redcurl."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.redcurl"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 2bc6 48 50 56 }
            // n = 4, score = 400
            //   2bc6                 | sub                 eax, esi
            //   48                   | dec                 eax
            //   50                   | push                eax
            //   56                   | push                esi

        $sequence_1 = { f7f9 80c261 88143e 47 }
            // n = 4, score = 400
            //   f7f9                 | idiv                ecx
            //   80c261               | add                 dl, 0x61
            //   88143e               | mov                 byte ptr [esi + edi], dl
            //   47                   | inc                 edi

        $sequence_2 = { ff15???????? 8bd0 c7461000000000 8bca }
            // n = 4, score = 400
            //   ff15????????         |                     
            //   8bd0                 | mov                 edx, eax
            //   c7461000000000       | mov                 dword ptr [esi + 0x10], 0
            //   8bca                 | mov                 ecx, edx

        $sequence_3 = { 6a00 6a00 6aff 8bf8 6a00 57 }
            // n = 6, score = 300
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6aff                 | push                -1
            //   8bf8                 | mov                 edi, eax
            //   6a00                 | push                0
            //   57                   | push                edi

        $sequence_4 = { 6a00 6a00 50 53 ff15???????? 6a00 6a00 }
            // n = 7, score = 300
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   50                   | push                eax
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_5 = { 85ff 747a 85c0 7476 6800010000 }
            // n = 5, score = 300
            //   85ff                 | test                edi, edi
            //   747a                 | je                  0x7c
            //   85c0                 | test                eax, eax
            //   7476                 | je                  0x78
            //   6800010000           | push                0x100

        $sequence_6 = { 8bf0 6a00 6a03 6a00 }
            // n = 4, score = 300
            //   8bf0                 | mov                 esi, eax
            //   6a00                 | push                0
            //   6a03                 | push                3
            //   6a00                 | push                0

        $sequence_7 = { 0f85e90b0000 eb00 f30f7e442404 660f2815???????? 660f28c8 }
            // n = 5, score = 300
            //   0f85e90b0000         | jne                 0xbef
            //   eb00                 | jmp                 2
            //   f30f7e442404         | movq                xmm0, qword ptr [esp + 4]
            //   660f2815????????     |                     
            //   660f28c8             | movapd              xmm1, xmm0

        $sequence_8 = { 8b4610 3bc2 726f 2bc2 }
            // n = 4, score = 300
            //   8b4610               | mov                 eax, dword ptr [esi + 0x10]
            //   3bc2                 | cmp                 eax, edx
            //   726f                 | jb                  0x71
            //   2bc2                 | sub                 eax, edx

        $sequence_9 = { 3bc2 0f42d0 0fb6041a 03d3 }
            // n = 4, score = 300
            //   3bc2                 | cmp                 eax, edx
            //   0f42d0               | cmovb               edx, eax
            //   0fb6041a             | movzx               eax, byte ptr [edx + ebx]
            //   03d3                 | add                 edx, ebx

        $sequence_10 = { e8???????? c745e800000000 c745ec0f000000 c645d800 8d5001 8b4610 }
            // n = 6, score = 300
            //   e8????????           |                     
            //   c745e800000000       | mov                 dword ptr [ebp - 0x18], 0
            //   c745ec0f000000       | mov                 dword ptr [ebp - 0x14], 0xf
            //   c645d800             | mov                 byte ptr [ebp - 0x28], 0
            //   8d5001               | lea                 edx, [eax + 1]
            //   8b4610               | mov                 eax, dword ptr [esi + 0x10]

        $sequence_11 = { 6a00 6a50 51 56 ff15???????? 8bd8 }
            // n = 6, score = 300
            //   6a00                 | push                0
            //   6a50                 | push                0x50
            //   51                   | push                ecx
            //   56                   | push                esi
            //   ff15????????         |                     
            //   8bd8                 | mov                 ebx, eax

        $sequence_12 = { 726f 2bc2 83c9ff 83f8ff 0f42c8 }
            // n = 5, score = 300
            //   726f                 | jb                  0x71
            //   2bc2                 | sub                 eax, edx
            //   83c9ff               | or                  ecx, 0xffffffff
            //   83f8ff               | cmp                 eax, -1
            //   0f42c8               | cmovb               ecx, eax

        $sequence_13 = { 8d4590 c7458c00000000 894588 c6459000 e8???????? }
            // n = 5, score = 200
            //   8d4590               | lea                 eax, [ebp - 0x70]
            //   c7458c00000000       | mov                 dword ptr [ebp - 0x74], 0
            //   894588               | mov                 dword ptr [ebp - 0x78], eax
            //   c6459000             | mov                 byte ptr [ebp - 0x70], 0
            //   e8????????           |                     

        $sequence_14 = { c70424???????? e8???????? 8b5304 83c001 83ec0c 39d0 }
            // n = 6, score = 200
            //   c70424????????       |                     
            //   e8????????           |                     
            //   8b5304               | mov                 edx, dword ptr [ebx + 4]
            //   83c001               | add                 eax, 1
            //   83ec0c               | sub                 esp, 0xc
            //   39d0                 | cmp                 eax, edx

        $sequence_15 = { c785acfcffff00000000 8985a8fcffff 8d8580fdffff c7442408???????? }
            // n = 4, score = 200
            //   c785acfcffff00000000     | mov    dword ptr [ebp - 0x354], 0
            //   8985a8fcffff         | mov                 dword ptr [ebp - 0x358], eax
            //   8d8580fdffff         | lea                 eax, [ebp - 0x280]
            //   c7442408????????     |                     

        $sequence_16 = { 0f84f31d0000 0fb60e 83c601 3dff000000 }
            // n = 4, score = 200
            //   0f84f31d0000         | je                  0x1df9
            //   0fb60e               | movzx               ecx, byte ptr [esi]
            //   83c601               | add                 esi, 1
            //   3dff000000           | cmp                 eax, 0xff

        $sequence_17 = { 0fb607 888598feffff 8b852cfdffff 89b594feffff }
            // n = 4, score = 200
            //   0fb607               | movzx               eax, byte ptr [edi]
            //   888598feffff         | mov                 byte ptr [ebp - 0x168], al
            //   8b852cfdffff         | mov                 eax, dword ptr [ebp - 0x2d4]
            //   89b594feffff         | mov                 dword ptr [ebp - 0x16c], esi

        $sequence_18 = { 0f84b70c0000 8bb538feffff 39f2 0f86c50a0000 }
            // n = 4, score = 200
            //   0f84b70c0000         | je                  0xcbd
            //   8bb538feffff         | mov                 esi, dword ptr [ebp - 0x1c8]
            //   39f2                 | cmp                 edx, esi
            //   0f86c50a0000         | jbe                 0xacb

        $sequence_19 = { 890424 e8???????? 8b85c4fbffff 83ec08 8d9510feffff }
            // n = 5, score = 200
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   8b85c4fbffff         | mov                 eax, dword ptr [ebp - 0x43c]
            //   83ec08               | sub                 esp, 8
            //   8d9510feffff         | lea                 edx, [ebp - 0x1f0]

        $sequence_20 = { 8944240c 8b856cfdffff 89442404 e8???????? 83ec10 8d8500fcffff }
            // n = 6, score = 200
            //   8944240c             | mov                 dword ptr [esp + 0xc], eax
            //   8b856cfdffff         | mov                 eax, dword ptr [ebp - 0x294]
            //   89442404             | mov                 dword ptr [esp + 4], eax
            //   e8????????           |                     
            //   83ec10               | sub                 esp, 0x10
            //   8d8500fcffff         | lea                 eax, [ebp - 0x400]

    condition:
        7 of them and filesize < 487424
}