rule win_redleaves_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.redleaves."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.redleaves"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 57 54 53 51 7565 7279 55 }
            // n = 7, score = 400
            //   57                   | push                edi
            //   54                   | push                esp
            //   53                   | push                ebx
            //   51                   | push                ecx
            //   7565                 | jne                 0x67
            //   7279                 | jb                  0x7b
            //   55                   | push                ebp

        $sequence_1 = { 59 89f9 8d64241c d2c0 }
            // n = 4, score = 400
            //   59                   | pop                 ecx
            //   89f9                 | mov                 ecx, edi
            //   8d64241c             | lea                 esp, [esp + 0x1c]
            //   d2c0                 | rol                 al, cl

        $sequence_2 = { 8d64241c d2c0 8a01 9c }
            // n = 4, score = 400
            //   8d64241c             | lea                 esp, [esp + 0x1c]
            //   d2c0                 | rol                 al, cl
            //   8a01                 | mov                 al, byte ptr [ecx]
            //   9c                   | pushfd              

        $sequence_3 = { 89d0 29f8 5f 5b }
            // n = 4, score = 400
            //   89d0                 | mov                 eax, edx
            //   29f8                 | sub                 eax, edi
            //   5f                   | pop                 edi
            //   5b                   | pop                 ebx

        $sequence_4 = { 9c 894504 9c 9c }
            // n = 4, score = 400
            //   9c                   | pushfd              
            //   894504               | mov                 dword ptr [ebp + 4], eax
            //   9c                   | pushfd              
            //   9c                   | pushfd              

        $sequence_5 = { 7279 55 7365 7254 }
            // n = 4, score = 400
            //   7279                 | jb                  0x7b
            //   55                   | push                ebp
            //   7365                 | jae                 0x67
            //   7254                 | jb                  0x56

        $sequence_6 = { 47 657449 7041 64647254 }
            // n = 4, score = 400
            //   47                   | inc                 edi
            //   657449               | je                  0x4c
            //   7041                 | jo                  0x43
            //   64647254             | jb                  0x58

        $sequence_7 = { 8bb6e4010000 85f6 7407 56 }
            // n = 4, score = 300
            //   8bb6e4010000         | mov                 esi, dword ptr [esi + 0x1e4]
            //   85f6                 | test                esi, esi
            //   7407                 | je                  9
            //   56                   | push                esi

        $sequence_8 = { 899e8c010000 66898e7c010000 89beac010000 899ea8010000 66898e98010000 b830750000 8d8e14020000 }
            // n = 7, score = 300
            //   899e8c010000         | mov                 dword ptr [esi + 0x18c], ebx
            //   66898e7c010000       | mov                 word ptr [esi + 0x17c], cx
            //   89beac010000         | mov                 dword ptr [esi + 0x1ac], edi
            //   899ea8010000         | mov                 dword ptr [esi + 0x1a8], ebx
            //   66898e98010000       | mov                 word ptr [esi + 0x198], cx
            //   b830750000           | mov                 eax, 0x7530
            //   8d8e14020000         | lea                 ecx, [esi + 0x214]

        $sequence_9 = { 9c 9c 8f442420 9c }
            // n = 4, score = 300
            //   9c                   | pushfd              
            //   9c                   | pushfd              
            //   8f442420             | pop                 dword ptr [esp + 0x20]
            //   9c                   | pushfd              

        $sequence_10 = { 7443 399df4fbffff 743b 7612 8b8df0fbffff 8b01 8d95f8fbffff }
            // n = 7, score = 300
            //   7443                 | je                  0x45
            //   399df4fbffff         | cmp                 dword ptr [ebp - 0x40c], ebx
            //   743b                 | je                  0x3d
            //   7612                 | jbe                 0x14
            //   8b8df0fbffff         | mov                 ecx, dword ptr [ebp - 0x410]
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   8d95f8fbffff         | lea                 edx, [ebp - 0x408]

        $sequence_11 = { 6880000000 50 e8???????? 8b85a4fdffff }
            // n = 4, score = 300
            //   6880000000           | push                0x80
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b85a4fdffff         | mov                 eax, dword ptr [ebp - 0x25c]

        $sequence_12 = { 85c0 7507 32c0 e9???????? 33c0 898598fdffff 399da0fdffff }
            // n = 7, score = 300
            //   85c0                 | test                eax, eax
            //   7507                 | jne                 9
            //   32c0                 | xor                 al, al
            //   e9????????           |                     
            //   33c0                 | xor                 eax, eax
            //   898598fdffff         | mov                 dword ptr [ebp - 0x268], eax
            //   399da0fdffff         | cmp                 dword ptr [ebp - 0x260], ebx

        $sequence_13 = { 7443 8d85acfeffff 68???????? 50 }
            // n = 4, score = 300
            //   7443                 | je                  0x45
            //   8d85acfeffff         | lea                 eax, [ebp - 0x154]
            //   68????????           |                     
            //   50                   | push                eax

        $sequence_14 = { 50 53 53 c78580fdffff4a000000 }
            // n = 4, score = 300
            //   50                   | push                eax
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   c78580fdffff4a000000     | mov    dword ptr [ebp - 0x280], 0x4a

        $sequence_15 = { 6a0d 59 663bc8 0f84c6000000 }
            // n = 4, score = 300
            //   6a0d                 | push                0xd
            //   59                   | pop                 ecx
            //   663bc8               | cmp                 cx, ax
            //   0f84c6000000         | je                  0xcc

        $sequence_16 = { 54 9c 60 9c }
            // n = 4, score = 300
            //   54                   | push                esp
            //   9c                   | pushfd              
            //   60                   | pushal              
            //   9c                   | pushfd              

    condition:
        7 of them and filesize < 1679360
}