rule win_redpepper_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.redpepper."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.redpepper"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 68???????? 6a15 8d562c 6aff }
            // n = 4, score = 300
            //   68????????           |                     
            //   6a15                 | push                0x15
            //   8d562c               | lea                 edx, [esi + 0x2c]
            //   6aff                 | push                -1

        $sequence_1 = { 8b500c 41 83f904 8b12 8a540aff }
            // n = 5, score = 300
            //   8b500c               | mov                 edx, dword ptr [eax + 0xc]
            //   41                   | inc                 ecx
            //   83f904               | cmp                 ecx, 4
            //   8b12                 | mov                 edx, dword ptr [edx]
            //   8a540aff             | mov                 dl, byte ptr [edx + ecx - 1]

        $sequence_2 = { 7405 e8???????? 8bc7 5f c9 }
            // n = 5, score = 300
            //   7405                 | je                  7
            //   e8????????           |                     
            //   8bc7                 | mov                 eax, edi
            //   5f                   | pop                 edi
            //   c9                   | leave               

        $sequence_3 = { 8b460c 85c0 7432 8b442420 }
            // n = 4, score = 300
            //   8b460c               | mov                 eax, dword ptr [esi + 0xc]
            //   85c0                 | test                eax, eax
            //   7432                 | je                  0x34
            //   8b442420             | mov                 eax, dword ptr [esp + 0x20]

        $sequence_4 = { 8b450c 2bc7 50 8d041f }
            // n = 4, score = 300
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   2bc7                 | sub                 eax, edi
            //   50                   | push                eax
            //   8d041f               | lea                 eax, [edi + ebx]

        $sequence_5 = { 6a01 8bcf 8bd8 e8???????? ff75fc }
            // n = 5, score = 300
            //   6a01                 | push                1
            //   8bcf                 | mov                 ecx, edi
            //   8bd8                 | mov                 ebx, eax
            //   e8????????           |                     
            //   ff75fc               | push                dword ptr [ebp - 4]

        $sequence_6 = { 6a65 6a20 e8???????? 83c428 8bc5 }
            // n = 5, score = 300
            //   6a65                 | push                0x65
            //   6a20                 | push                0x20
            //   e8????????           |                     
            //   83c428               | add                 esp, 0x28
            //   8bc5                 | mov                 eax, ebp

        $sequence_7 = { 3c0a 741e 8365f800 3c0d 7503 895df8 3b750c }
            // n = 7, score = 300
            //   3c0a                 | cmp                 al, 0xa
            //   741e                 | je                  0x20
            //   8365f800             | and                 dword ptr [ebp - 8], 0
            //   3c0d                 | cmp                 al, 0xd
            //   7503                 | jne                 5
            //   895df8               | mov                 dword ptr [ebp - 8], ebx
            //   3b750c               | cmp                 esi, dword ptr [ebp + 0xc]

        $sequence_8 = { 83c404 85c0 7411 8b4c2418 5f }
            // n = 5, score = 300
            //   83c404               | add                 esp, 4
            //   85c0                 | test                eax, eax
            //   7411                 | je                  0x13
            //   8b4c2418             | mov                 ecx, dword ptr [esp + 0x18]
            //   5f                   | pop                 edi

        $sequence_9 = { 8d85b4feffff 50 56 ff15???????? 56 }
            // n = 5, score = 300
            //   8d85b4feffff         | lea                 eax, [ebp - 0x14c]
            //   50                   | push                eax
            //   56                   | push                esi
            //   ff15????????         |                     
            //   56                   | push                esi

    condition:
        7 of them and filesize < 2482176
}