rule win_redshawl_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.redshawl."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.redshawl"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4889442438 895c2430 4489642428 4c89642420 4533c9 4c8bc6 488d942430010000 }
            // n = 7, score = 100
            //   4889442438           | mov                 ecx, esi
            //   895c2430             | dec                 eax
            //   4489642428           | mov                 ecx, eax
            //   4c89642420           | dec                 eax
            //   4533c9               | lea                 edx, [0xa2c1]
            //   4c8bc6               | dec                 ecx
            //   488d942430010000     | mov                 ecx, esp

        $sequence_1 = { 488b4c2448 e8???????? 90 90 e9???????? 488d542450 418bcc }
            // n = 7, score = 100
            //   488b4c2448           | inc                 ebx
            //   e8????????           |                     
            //   90                   | dec                 eax
            //   90                   | inc                 ecx
            //   e9????????           |                     
            //   488d542450           | test                al, al
            //   418bcc               | jne                 0x83

        $sequence_2 = { 7329 4863d1 488d0d90770000 488bc2 }
            // n = 4, score = 100
            //   7329                 | dec                 eax
            //   4863d1               | mov                 dword ptr [esp + 8], ebx
            //   488d0d90770000       | push                edi
            //   488bc2               | dec                 eax

        $sequence_3 = { 488d8c2431010000 e8???????? ba04010000 488d8c2440020000 ff15???????? 4c8bde 488d8c2430010000 }
            // n = 7, score = 100
            //   488d8c2431010000     | mov                 eax, dword ptr [esp + 0x48]
            //   e8????????           |                     
            //   ba04010000           | dec                 eax
            //   488d8c2440020000     | lea                 edx, [esp + 0x6c]
            //   ff15????????         |                     
            //   4c8bde               | dec                 eax
            //   488d8c2430010000     | lea                 ecx, [0x9f96]

        $sequence_4 = { 3b3d???????? 737d 488bdf 488bf7 48c1fe05 4c8d25ea7e0000 }
            // n = 6, score = 100
            //   3b3d????????         |                     
            //   737d                 | lea                 edx, [0x7deb]
            //   488bdf               | dec                 eax
            //   488bf7               | sar                 eax, 5
            //   48c1fe05             | and                 ecx, 0x1f
            //   4c8d25ea7e0000       | dec                 eax

        $sequence_5 = { 4c8be9 488b05???????? 4885c0 0f8436010000 48833d????????00 }
            // n = 5, score = 100
            //   4c8be9               | mov                 ecx, 0x1100
            //   488b05????????       |                     
            //   4885c0               | dec                 esp
            //   0f8436010000         | mov                 eax, dword ptr [ebp + 0xb8]
            //   48833d????????00     |                     

        $sequence_6 = { 48895c2408 57 4883ec20 488d1d0b6d0000 488d3d046d0000 }
            // n = 5, score = 100
            //   48895c2408           | dec                 esp
            //   57                   | lea                 esp, [0x9455]
            //   4883ec20             | mov                 dword ptr [eax - 0x58], 0
            //   488d1d0b6d0000       | or                  esi, 0xffffffff
            //   488d3d046d0000       | mov                 dword ptr [eax + 8], esi

        $sequence_7 = { 7532 488d0d239d0000 e8???????? ff15???????? 89442460 488d150c000000 }
            // n = 6, score = 100
            //   7532                 | dec                 eax
            //   488d0d239d0000       | test                eax, eax
            //   e8????????           |                     
            //   ff15????????         |                     
            //   89442460             | je                  0x542
            //   488d150c000000       | dec                 eax

        $sequence_8 = { 8364242800 41b803000000 488d0d6c320000 4533c9 ba00000040 4489442420 }
            // n = 6, score = 100
            //   8364242800           | dec                 eax
            //   41b803000000         | dec                 esi
            //   488d0d6c320000       | jne                 0x159
            //   4533c9               | dec                 eax
            //   ba00000040           | lea                 ebx, [0x98d7]
            //   4489442420           | dec                 eax

        $sequence_9 = { 418bcc e8???????? 8bd8 89442440 85c0 }
            // n = 5, score = 100
            //   418bcc               | inc                 ebp
            //   e8????????           |                     
            //   8bd8                 | test                esp, esp
            //   89442440             | jne                 0xa23
            //   85c0                 | dec                 eax

    condition:
        7 of them and filesize < 174080
}