rule win_redyms_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.redyms."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.redyms"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c745d800000000 8b7dd8 56 6a00 ff15???????? }
            // n = 5, score = 100
            //   c745d800000000       | mov                 dword ptr [ebp - 0x28], 0
            //   8b7dd8               | mov                 edi, dword ptr [ebp - 0x28]
            //   56                   | push                esi
            //   6a00                 | push                0
            //   ff15????????         |                     

        $sequence_1 = { 53 03f7 56 57 e8???????? 83c40c }
            // n = 6, score = 100
            //   53                   | push                ebx
            //   03f7                 | add                 esi, edi
            //   56                   | push                esi
            //   57                   | push                edi
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_2 = { 2bf7 03c7 83ee02 56 8d540802 52 53 }
            // n = 7, score = 100
            //   2bf7                 | sub                 esi, edi
            //   03c7                 | add                 eax, edi
            //   83ee02               | sub                 esi, 2
            //   56                   | push                esi
            //   8d540802             | lea                 edx, [eax + ecx + 2]
            //   52                   | push                edx
            //   53                   | push                ebx

        $sequence_3 = { b8???????? ffd0 898590feffff 85c0 }
            // n = 4, score = 100
            //   b8????????           |                     
            //   ffd0                 | call                eax
            //   898590feffff         | mov                 dword ptr [ebp - 0x170], eax
            //   85c0                 | test                eax, eax

        $sequence_4 = { 8b856cfdffff 50 ff15???????? 6a09 8d8d74feffff 51 68???????? }
            // n = 7, score = 100
            //   8b856cfdffff         | mov                 eax, dword ptr [ebp - 0x294]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   6a09                 | push                9
            //   8d8d74feffff         | lea                 ecx, [ebp - 0x18c]
            //   51                   | push                ecx
            //   68????????           |                     

        $sequence_5 = { 8b0f 014b2c 8b4b2c 85c0 7571 }
            // n = 5, score = 100
            //   8b0f                 | mov                 ecx, dword ptr [edi]
            //   014b2c               | add                 dword ptr [ebx + 0x2c], ecx
            //   8b4b2c               | mov                 ecx, dword ptr [ebx + 0x2c]
            //   85c0                 | test                eax, eax
            //   7571                 | jne                 0x73

        $sequence_6 = { 85ff 7433 8b95ecfeffff 83c2fc }
            // n = 4, score = 100
            //   85ff                 | test                edi, edi
            //   7433                 | je                  0x35
            //   8b95ecfeffff         | mov                 edx, dword ptr [ebp - 0x114]
            //   83c2fc               | add                 edx, -4

        $sequence_7 = { 740b 50 53 ff15???????? 50 ffd6 8b45d4 }
            // n = 7, score = 100
            //   740b                 | je                  0xd
            //   50                   | push                eax
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   8b45d4               | mov                 eax, dword ptr [ebp - 0x2c]

        $sequence_8 = { 6a00 68???????? 68???????? 51 56 }
            // n = 5, score = 100
            //   6a00                 | push                0
            //   68????????           |                     
            //   68????????           |                     
            //   51                   | push                ecx
            //   56                   | push                esi

        $sequence_9 = { 8bf0 85f6 740c 8b550c 57 52 56 }
            // n = 7, score = 100
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi
            //   740c                 | je                  0xe
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   57                   | push                edi
            //   52                   | push                edx
            //   56                   | push                esi

    condition:
        7 of them and filesize < 98304
}