rule win_reedbed_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.reedbed."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.reedbed"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33c9 e8???????? 488b0d???????? 488981c2140000 }
            // n = 4, score = 300
            //   33c9                 | xor                 ecx, ecx
            //   e8????????           |                     
            //   488b0d????????       |                     
            //   488981c2140000       | dec                 eax

        $sequence_1 = { 33c9 ff15???????? 85c0 751e }
            // n = 4, score = 300
            //   33c9                 | xor                 ecx, ecx
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   751e                 | jne                 0x20

        $sequence_2 = { 4885c9 7405 e8???????? 33c0 0f57c0 }
            // n = 5, score = 200
            //   4885c9               | dec                 eax
            //   7405                 | add                 ecx, 0x3f
            //   e8????????           |                     
            //   33c0                 | dec                 eax
            //   0f57c0               | cmp                 ecx, edi

        $sequence_3 = { eb19 488d15e3d10100 eb10 488d15cad10100 eb07 488d15b5d10100 4533c0 }
            // n = 7, score = 200
            //   eb19                 | jl                  0xfffffff0
            //   488d15e3d10100       | xor                 ecx, ecx
            //   eb10                 | dec                 eax
            //   488d15cad10100       | test                ecx, ecx
            //   eb07                 | je                  0xa
            //   488d15b5d10100       | xor                 eax, eax
            //   4533c0               | xorps               xmm0, xmm0

        $sequence_4 = { 4c8d0d44e50000 b919000000 4c8d0534e50000 488d1531e50000 e8???????? }
            // n = 5, score = 200
            //   4c8d0d44e50000       | xor                 eax, eax
            //   b919000000           | and                 dword ptr [esp + 0x40], 0
            //   4c8d0534e50000       | dec                 esp
            //   488d1531e50000       | lea                 ecx, [esp + 0x40]
            //   e8????????           |                     

        $sequence_5 = { 488bd8 4885c0 7431 488bc8 ff15???????? 83f8ff }
            // n = 6, score = 200
            //   488bd8               | lea                 edx, [0x1d1ca]
            //   4885c0               | jmp                 0x12
            //   7431                 | dec                 eax
            //   488bc8               | lea                 edx, [0x1d1b5]
            //   ff15????????         |                     
            //   83f8ff               | inc                 ebp

        $sequence_6 = { 8364244000 4c8d4c2440 baffff0000 c744242004000000 41b801000000 }
            // n = 5, score = 200
            //   8364244000           | jmp                 0x1b
            //   4c8d4c2440           | dec                 eax
            //   baffff0000           | lea                 edx, [0x1d1e3]
            //   c744242004000000     | jmp                 0x12
            //   41b801000000         | dec                 eax

        $sequence_7 = { 488b83a6140000 4c8974080e 4883c13f 483bcf 7ceb e8???????? 33c9 }
            // n = 7, score = 200
            //   488b83a6140000       | dec                 eax
            //   4c8974080e           | mov                 dword ptr [ecx + 0x14c2], eax
            //   4883c13f             | dec                 eax
            //   483bcf               | mov                 eax, dword ptr [ebx + 0x14a6]
            //   7ceb                 | dec                 esp
            //   e8????????           |                     
            //   33c9                 | mov                 dword ptr [eax + ecx + 0xe], esi

        $sequence_8 = { c7450400000000 c7452400000000 488b8548010000 83780a00 }
            // n = 4, score = 100
            //   c7450400000000       | xor                 ecx, ecx
            //   c7452400000000       | mov                 dword ptr [ebp + 4], 0
            //   488b8548010000       | cmp                 dword ptr [ebp + 0x108], 0
            //   83780a00             | jne                 0x17

        $sequence_9 = { c7450400000000 c7452400000000 488b85a0010000 4883b8a614000000 }
            // n = 4, score = 100
            //   c7450400000000       | mov                 ecx, dword ptr [ebp + 0x100]
            //   c7452400000000       | mov                 dword ptr [ebp + 4], 0
            //   488b85a0010000       | mov                 edx, 1
            //   4883b8a614000000     | mov                 ecx, 0x3f0000

        $sequence_10 = { c7450400000000 83bd0801000000 7515 488d15ce130f00 }
            // n = 4, score = 100
            //   c7450400000000       | dec                 esp
            //   83bd0801000000       | lea                 ecx, [0xe544]
            //   7515                 | mov                 ecx, 0x19
            //   488d15ce130f00       | dec                 esp

        $sequence_11 = { c7450400000000 ba01000000 b900003f00 e8???????? }
            // n = 4, score = 100
            //   c7450400000000       | mov                 dword ptr [ebp + 4], 0
            //   ba01000000           | cmp                 dword ptr [ebp + 4], 0
            //   b900003f00           | jne                 0x36
            //   e8????????           |                     

        $sequence_12 = { c7450400000000 c7452400000000 488b8540010000 8b808c140000 }
            // n = 4, score = 100
            //   c7450400000000       | cmp                 dword ptr [eax], 0
            //   c7452400000000       | je                  0x4e
            //   488b8540010000       | mov                 dword ptr [ebp + 4], 0
            //   8b808c140000         | cmp                 dword ptr [ebp + 4], 0

        $sequence_13 = { c7450400000000 837d0400 7534 488b8580010000 }
            // n = 4, score = 100
            //   c7450400000000       | dec                 eax
            //   837d0400             | lea                 edx, [0x1d1ca]
            //   7534                 | jmp                 9
            //   488b8580010000       | dec                 eax

    condition:
        7 of them and filesize < 3760128
}