rule win_regretlocker_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.regretlocker."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.regretlocker"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 8d4d8f e8???????? 8bf8 6a20 58 ff35???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8d4d8f               | lea                 ecx, [ebp - 0x71]
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   6a20                 | push                0x20
            //   58                   | pop                 eax
            //   ff35????????         |                     

        $sequence_1 = { 7202 8b09 6a00 51 e8???????? 83f8ff }
            // n = 6, score = 100
            //   7202                 | jb                  4
            //   8b09                 | mov                 ecx, dword ptr [ecx]
            //   6a00                 | push                0
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83f8ff               | cmp                 eax, -1

        $sequence_2 = { 8d8560feffff 8bce 50 e8???????? 84c0 746b }
            // n = 6, score = 100
            //   8d8560feffff         | lea                 eax, [ebp - 0x1a0]
            //   8bce                 | mov                 ecx, esi
            //   50                   | push                eax
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   746b                 | je                  0x6d

        $sequence_3 = { e9???????? 8b4df0 83c12c e9???????? 8d4dd8 e9???????? b8???????? }
            // n = 7, score = 100
            //   e9????????           |                     
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   83c12c               | add                 ecx, 0x2c
            //   e9????????           |                     
            //   8d4dd8               | lea                 ecx, [ebp - 0x28]
            //   e9????????           |                     
            //   b8????????           |                     

        $sequence_4 = { eb4c 8b08 80790d00 7439 8b4804 80790d00 }
            // n = 6, score = 100
            //   eb4c                 | jmp                 0x4e
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   80790d00             | cmp                 byte ptr [ecx + 0xd], 0
            //   7439                 | je                  0x3b
            //   8b4804               | mov                 ecx, dword ptr [eax + 4]
            //   80790d00             | cmp                 byte ptr [ecx + 0xd], 0

        $sequence_5 = { 8b01 8945ec 3bc1 0f84c5000000 8855e8 33ff 8855e4 }
            // n = 7, score = 100
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax
            //   3bc1                 | cmp                 eax, ecx
            //   0f84c5000000         | je                  0xcb
            //   8855e8               | mov                 byte ptr [ebp - 0x18], dl
            //   33ff                 | xor                 edi, edi
            //   8855e4               | mov                 byte ptr [ebp - 0x1c], dl

        $sequence_6 = { a5 a5 8d7dec ab ab }
            // n = 5, score = 100
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]
            //   8d7dec               | lea                 edi, [ebp - 0x14]
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   ab                   | stosd               dword ptr es:[edi], eax

        $sequence_7 = { 56 57 8b7d08 8bf1 3bf7 742b 8d4718 }
            // n = 7, score = 100
            //   56                   | push                esi
            //   57                   | push                edi
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   8bf1                 | mov                 esi, ecx
            //   3bf7                 | cmp                 esi, edi
            //   742b                 | je                  0x2d
            //   8d4718               | lea                 eax, [edi + 0x18]

        $sequence_8 = { 8bc1 2b45cc 99 f7fb c645fc02 8bf0 8b45c4 }
            // n = 7, score = 100
            //   8bc1                 | mov                 eax, ecx
            //   2b45cc               | sub                 eax, dword ptr [ebp - 0x34]
            //   99                   | cdq                 
            //   f7fb                 | idiv                ebx
            //   c645fc02             | mov                 byte ptr [ebp - 4], 2
            //   8bf0                 | mov                 esi, eax
            //   8b45c4               | mov                 eax, dword ptr [ebp - 0x3c]

        $sequence_9 = { 5b 85c0 0f8569ffffff 8b4df4 8bc6 5f 5e }
            // n = 7, score = 100
            //   5b                   | pop                 ebx
            //   85c0                 | test                eax, eax
            //   0f8569ffffff         | jne                 0xffffff6f
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   8bc6                 | mov                 eax, esi
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

    condition:
        7 of them and filesize < 1021952
}