rule win_rekoobew_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.rekoobew."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rekoobew"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b75bc 3375c4 3375d8 3375ec }
            // n = 4, score = 100
            //   8b75bc               | mov                 esi, dword ptr [ebp - 0x44]
            //   3375c4               | xor                 esi, dword ptr [ebp - 0x3c]
            //   3375d8               | xor                 esi, dword ptr [ebp - 0x28]
            //   3375ec               | xor                 esi, dword ptr [ebp - 0x14]

        $sequence_1 = { 0fb6fe 89ca 3314bde08c4000 0fb6f2 8b3cb5e0904000 }
            // n = 5, score = 100
            //   0fb6fe               | movzx               edi, dh
            //   89ca                 | mov                 edx, ecx
            //   3314bde08c4000       | xor                 edx, dword ptr [edi*4 + 0x408ce0]
            //   0fb6f2               | movzx               esi, dl
            //   8b3cb5e0904000       | mov                 edi, dword ptr [esi*4 + 0x4090e0]

        $sequence_2 = { 894714 83c201 83fa08 7588 }
            // n = 4, score = 100
            //   894714               | mov                 dword ptr [edi + 0x14], eax
            //   83c201               | add                 edx, 1
            //   83fa08               | cmp                 edx, 8
            //   7588                 | jne                 0xffffff8a

        $sequence_3 = { 33348de0704000 8b4de8 c1e910 0fb6c9 33348de0744000 8975e0 }
            // n = 6, score = 100
            //   33348de0704000       | xor                 esi, dword ptr [ecx*4 + 0x4070e0]
            //   8b4de8               | mov                 ecx, dword ptr [ebp - 0x18]
            //   c1e910               | shr                 ecx, 0x10
            //   0fb6c9               | movzx               ecx, cl
            //   33348de0744000       | xor                 esi, dword ptr [ecx*4 + 0x4074e0]
            //   8975e0               | mov                 dword ptr [ebp - 0x20], esi

        $sequence_4 = { 3c0d 745e 80f93d 0f85a0feffff 89f0 eb53 b8ffffffff }
            // n = 7, score = 100
            //   3c0d                 | cmp                 al, 0xd
            //   745e                 | je                  0x60
            //   80f93d               | cmp                 cl, 0x3d
            //   0f85a0feffff         | jne                 0xfffffea6
            //   89f0                 | mov                 eax, esi
            //   eb53                 | jmp                 0x55
            //   b8ffffffff           | mov                 eax, 0xffffffff

        $sequence_5 = { 894de0 0fb67004 c1e618 0fb65005 c1e210 09f2 0fb67007 }
            // n = 7, score = 100
            //   894de0               | mov                 dword ptr [ebp - 0x20], ecx
            //   0fb67004             | movzx               esi, byte ptr [eax + 4]
            //   c1e618               | shl                 esi, 0x18
            //   0fb65005             | movzx               edx, byte ptr [eax + 5]
            //   c1e210               | shl                 edx, 0x10
            //   09f2                 | or                  edx, esi
            //   0fb67007             | movzx               esi, byte ptr [eax + 7]

        $sequence_6 = { 0f84c5000000 8b5078 85d2 0f84ba000000 8b35???????? 85f6 }
            // n = 6, score = 100
            //   0f84c5000000         | je                  0xcb
            //   8b5078               | mov                 edx, dword ptr [eax + 0x78]
            //   85d2                 | test                edx, edx
            //   0f84ba000000         | je                  0xc0
            //   8b35????????         |                     
            //   85f6                 | test                esi, esi

        $sequence_7 = { 33735c 89d7 c1ef18 3334bde0844000 89cf c1ef10 81e7ff000000 }
            // n = 7, score = 100
            //   33735c               | xor                 esi, dword ptr [ebx + 0x5c]
            //   89d7                 | mov                 edi, edx
            //   c1ef18               | shr                 edi, 0x18
            //   3334bde0844000       | xor                 esi, dword ptr [edi*4 + 0x4084e0]
            //   89cf                 | mov                 edi, ecx
            //   c1ef10               | shr                 edi, 0x10
            //   81e7ff000000         | and                 edi, 0xff

        $sequence_8 = { 09d7 0fb64827 09cf 0fb65026 c1e208 09d7 897dc8 }
            // n = 7, score = 100
            //   09d7                 | or                  edi, edx
            //   0fb64827             | movzx               ecx, byte ptr [eax + 0x27]
            //   09cf                 | or                  edi, ecx
            //   0fb65026             | movzx               edx, byte ptr [eax + 0x26]
            //   c1e208               | shl                 edx, 8
            //   09d7                 | or                  edi, edx
            //   897dc8               | mov                 dword ptr [ebp - 0x38], edi

        $sequence_9 = { e8???????? 85c0 7916 c704240f000000 e8???????? b828000000 e9???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7916                 | jns                 0x18
            //   c704240f000000       | mov                 dword ptr [esp], 0xf
            //   e8????????           |                     
            //   b828000000           | mov                 eax, 0x28
            //   e9????????           |                     

    condition:
        7 of them and filesize < 248832
}