rule win_remcom_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.remcom."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.remcom"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a02 68???????? ffd7 8d4df4 51 6aff 6a00 }
            // n = 7, score = 100
            //   6a02                 | push                2
            //   68????????           |                     
            //   ffd7                 | call                edi
            //   8d4df4               | lea                 ecx, [ebp - 0xc]
            //   51                   | push                ecx
            //   6aff                 | push                -1
            //   6a00                 | push                0

        $sequence_1 = { 033485e0fc4000 c745e401000000 33db 395e08 7536 6a0a e8???????? }
            // n = 7, score = 100
            //   033485e0fc4000       | add                 esi, dword ptr [eax*4 + 0x40fce0]
            //   c745e401000000       | mov                 dword ptr [ebp - 0x1c], 1
            //   33db                 | xor                 ebx, ebx
            //   395e08               | cmp                 dword ptr [esi + 8], ebx
            //   7536                 | jne                 0x38
            //   6a0a                 | push                0xa
            //   e8????????           |                     

        $sequence_2 = { e8???????? 8be5 5d c3 53 56 8d95f8feffff }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   53                   | push                ebx
            //   56                   | push                esi
            //   8d95f8feffff         | lea                 edx, [ebp - 0x108]

        $sequence_3 = { 56 8b7508 57 8b7d0c 6a44 }
            // n = 5, score = 100
            //   56                   | push                esi
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   57                   | push                edi
            //   8b7d0c               | mov                 edi, dword ptr [ebp + 0xc]
            //   6a44                 | push                0x44

        $sequence_4 = { ff15???????? 6a00 6a00 6a01 8d4de0 }
            // n = 5, score = 100
            //   ff15????????         |                     
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a01                 | push                1
            //   8d4de0               | lea                 ecx, [ebp - 0x20]

        $sequence_5 = { 33c0 57 8945f8 8945fc 6a01 8d45e0 }
            // n = 6, score = 100
            //   33c0                 | xor                 eax, eax
            //   57                   | push                edi
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   6a01                 | push                1
            //   8d45e0               | lea                 eax, [ebp - 0x20]

        $sequence_6 = { 8b7508 57 8b7d0c 6a44 8d85a0feffff }
            // n = 5, score = 100
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   57                   | push                edi
            //   8b7d0c               | mov                 edi, dword ptr [ebp + 0xc]
            //   6a44                 | push                0x44
            //   8d85a0feffff         | lea                 eax, [ebp - 0x160]

        $sequence_7 = { 8bf8 3bfb 746a 56 68ff010f00 68???????? }
            // n = 6, score = 100
            //   8bf8                 | mov                 edi, eax
            //   3bfb                 | cmp                 edi, ebx
            //   746a                 | je                  0x6c
            //   56                   | push                esi
            //   68ff010f00           | push                0xf01ff
            //   68????????           |                     

        $sequence_8 = { ffd7 8945f0 eb51 33db 391e 763d }
            // n = 6, score = 100
            //   ffd7                 | call                edi
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   eb51                 | jmp                 0x53
            //   33db                 | xor                 ebx, ebx
            //   391e                 | cmp                 dword ptr [esi], ebx
            //   763d                 | jbe                 0x3f

        $sequence_9 = { 50 6814120000 8d8de8edffff 51 56 }
            // n = 5, score = 100
            //   50                   | push                eax
            //   6814120000           | push                0x1214
            //   8d8de8edffff         | lea                 ecx, [ebp - 0x1218]
            //   51                   | push                ecx
            //   56                   | push                esi

    condition:
        7 of them and filesize < 155648
}