rule win_remcos_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.remcos."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.remcos"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85c0 7410 6a00 ff35???????? }
            // n = 4, score = 2100
            //   85c0                 | test                eax, eax
            //   7410                 | je                  0x12
            //   6a00                 | push                0
            //   ff35????????         |                     

        $sequence_1 = { ff15???????? 50 ff15???????? 8d45f0 33f6 }
            // n = 5, score = 2100
            //   ff15????????         |                     
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   33f6                 | xor                 esi, esi

        $sequence_2 = { 51 51 8d45f8 c745f808000000 50 ff15???????? ff15???????? }
            // n = 7, score = 2100
            //   51                   | push                ecx
            //   51                   | push                ecx
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   c745f808000000       | mov                 dword ptr [ebp - 8], 8
            //   50                   | push                eax
            //   ff15????????         |                     
            //   ff15????????         |                     

        $sequence_3 = { ff15???????? 50 ff15???????? 8d45f0 33f6 50 }
            // n = 6, score = 2100
            //   ff15????????         |                     
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   33f6                 | xor                 esi, esi
            //   50                   | push                eax

        $sequence_4 = { 85c0 7410 6a00 ff35???????? ff15???????? }
            // n = 5, score = 2100
            //   85c0                 | test                eax, eax
            //   7410                 | je                  0x12
            //   6a00                 | push                0
            //   ff35????????         |                     
            //   ff15????????         |                     

        $sequence_5 = { 50 6a28 ff15???????? 50 ff15???????? 8d45f0 33f6 }
            // n = 7, score = 2100
            //   50                   | push                eax
            //   6a28                 | push                0x28
            //   ff15????????         |                     
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   33f6                 | xor                 esi, esi

        $sequence_6 = { 7410 6a00 ff35???????? ff15???????? }
            // n = 4, score = 2100
            //   7410                 | je                  0x12
            //   6a00                 | push                0
            //   ff35????????         |                     
            //   ff15????????         |                     

        $sequence_7 = { 8d45f8 50 ff15???????? ff7508 }
            // n = 4, score = 2100
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   ff7508               | push                dword ptr [ebp + 8]

        $sequence_8 = { 51 8d45f8 c745f808000000 50 ff15???????? ff15???????? }
            // n = 6, score = 2100
            //   51                   | push                ecx
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   c745f808000000       | mov                 dword ptr [ebp - 8], 8
            //   50                   | push                eax
            //   ff15????????         |                     
            //   ff15????????         |                     

        $sequence_9 = { 8d45f8 50 ff15???????? ff7508 ff15???????? }
            // n = 5, score = 2100
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ff15????????         |                     

    condition:
        7 of them and filesize < 1054720
}