rule win_remy_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.remy."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.remy"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 668945e1 8845e3 8b4508 885ddc 50 b808000000 8d5ddc }
            // n = 7, score = 200
            //   668945e1             | mov                 word ptr [ebp - 0x1f], ax
            //   8845e3               | mov                 byte ptr [ebp - 0x1d], al
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   885ddc               | mov                 byte ptr [ebp - 0x24], bl
            //   50                   | push                eax
            //   b808000000           | mov                 eax, 8
            //   8d5ddc               | lea                 ebx, [ebp - 0x24]

        $sequence_1 = { 899c24a0000000 89bc24c0000000 899c24c4000000 899c24c8000000 8b442410 8d542418 52 }
            // n = 7, score = 200
            //   899c24a0000000       | mov                 dword ptr [esp + 0xa0], ebx
            //   89bc24c0000000       | mov                 dword ptr [esp + 0xc0], edi
            //   899c24c4000000       | mov                 dword ptr [esp + 0xc4], ebx
            //   899c24c8000000       | mov                 dword ptr [esp + 0xc8], ebx
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]
            //   8d542418             | lea                 edx, [esp + 0x18]
            //   52                   | push                edx

        $sequence_2 = { 83c404 8db558ffffff e8???????? c645fc01 8b08 8bb564ffffff 8d41f0 }
            // n = 7, score = 200
            //   83c404               | add                 esp, 4
            //   8db558ffffff         | lea                 esi, [ebp - 0xa8]
            //   e8????????           |                     
            //   c645fc01             | mov                 byte ptr [ebp - 4], 1
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   8bb564ffffff         | mov                 esi, dword ptr [ebp - 0x9c]
            //   8d41f0               | lea                 eax, [ecx - 0x10]

        $sequence_3 = { 746e 50 e8???????? 8bf0 eb66 8d4de0 }
            // n = 6, score = 200
            //   746e                 | je                  0x70
            //   50                   | push                eax
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   eb66                 | jmp                 0x68
            //   8d4de0               | lea                 ecx, [ebp - 0x20]

        $sequence_4 = { 8b4d20 b802000000 c745fc00000000 51 6689459c ff15???????? }
            // n = 6, score = 200
            //   8b4d20               | mov                 ecx, dword ptr [ebp + 0x20]
            //   b802000000           | mov                 eax, 2
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   51                   | push                ecx
            //   6689459c             | mov                 word ptr [ebp - 0x64], ax
            //   ff15????????         |                     

        $sequence_5 = { 8d8d4cffffff 8d9548feffff 898500feffff 898d04feffff 899508feffff 8d853cffffff 8d8d94feffff }
            // n = 7, score = 200
            //   8d8d4cffffff         | lea                 ecx, [ebp - 0xb4]
            //   8d9548feffff         | lea                 edx, [ebp - 0x1b8]
            //   898500feffff         | mov                 dword ptr [ebp - 0x200], eax
            //   898d04feffff         | mov                 dword ptr [ebp - 0x1fc], ecx
            //   899508feffff         | mov                 dword ptr [ebp - 0x1f8], edx
            //   8d853cffffff         | lea                 eax, [ebp - 0xc4]
            //   8d8d94feffff         | lea                 ecx, [ebp - 0x16c]

        $sequence_6 = { c70001000000 8b4620 50 895dac 895da8 ff15???????? 83f8ff }
            // n = 7, score = 200
            //   c70001000000         | mov                 dword ptr [eax], 1
            //   8b4620               | mov                 eax, dword ptr [esi + 0x20]
            //   50                   | push                eax
            //   895dac               | mov                 dword ptr [ebp - 0x54], ebx
            //   895da8               | mov                 dword ptr [ebp - 0x58], ebx
            //   ff15????????         |                     
            //   83f8ff               | cmp                 eax, -1

        $sequence_7 = { c684243003000002 c7842480010000fe454c35 66c7842484010000fe4c c684248601000000 8d842480010000 800027 40 }
            // n = 7, score = 200
            //   c684243003000002     | mov                 byte ptr [esp + 0x330], 2
            //   c7842480010000fe454c35     | mov    dword ptr [esp + 0x180], 0x354c45fe
            //   66c7842484010000fe4c     | mov    word ptr [esp + 0x184], 0x4cfe
            //   c684248601000000     | mov                 byte ptr [esp + 0x186], 0
            //   8d842480010000       | lea                 eax, [esp + 0x180]
            //   800027               | add                 byte ptr [eax], 0x27
            //   40                   | inc                 eax

        $sequence_8 = { 52 6806100000 68ffff0000 56 ff15???????? 6a04 8d45d0 }
            // n = 7, score = 200
            //   52                   | push                edx
            //   6806100000           | push                0x1006
            //   68ffff0000           | push                0xffff
            //   56                   | push                esi
            //   ff15????????         |                     
            //   6a04                 | push                4
            //   8d45d0               | lea                 eax, [ebp - 0x30]

        $sequence_9 = { 8bce e8???????? 837e1410 7202 8b36 8d472c }
            // n = 6, score = 200
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   837e1410             | cmp                 dword ptr [esi + 0x14], 0x10
            //   7202                 | jb                  4
            //   8b36                 | mov                 esi, dword ptr [esi]
            //   8d472c               | lea                 eax, [edi + 0x2c]

    condition:
        7 of them and filesize < 507904
}