rule win_rerdom_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.rerdom."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rerdom"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 72f0 8bc3 e8???????? 8d45e4 50 ff15???????? 8b4510 }
            // n = 7, score = 200
            //   72f0                 | jb                  0xfffffff2
            //   8bc3                 | mov                 eax, ebx
            //   e8????????           |                     
            //   8d45e4               | lea                 eax, [ebp - 0x1c]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]

        $sequence_1 = { 7406 c70003010000 85db 740f 53 ff742408 e8???????? }
            // n = 7, score = 200
            //   7406                 | je                  8
            //   c70003010000         | mov                 dword ptr [eax], 0x103
            //   85db                 | test                ebx, ebx
            //   740f                 | je                  0x11
            //   53                   | push                ebx
            //   ff742408             | push                dword ptr [esp + 8]
            //   e8????????           |                     

        $sequence_2 = { 754d 8b4604 3bc3 7346 3b4608 7341 }
            // n = 6, score = 200
            //   754d                 | jne                 0x4f
            //   8b4604               | mov                 eax, dword ptr [esi + 4]
            //   3bc3                 | cmp                 eax, ebx
            //   7346                 | jae                 0x48
            //   3b4608               | cmp                 eax, dword ptr [esi + 8]
            //   7341                 | jae                 0x43

        $sequence_3 = { 743d 83fb09 7338 8d4704 56 50 8945fc }
            // n = 7, score = 200
            //   743d                 | je                  0x3f
            //   83fb09               | cmp                 ebx, 9
            //   7338                 | jae                 0x3a
            //   8d4704               | lea                 eax, [edi + 4]
            //   56                   | push                esi
            //   50                   | push                eax
            //   8945fc               | mov                 dword ptr [ebp - 4], eax

        $sequence_4 = { 894618 85c0 0f84c8000000 a1???????? 85c0 7522 68???????? }
            // n = 7, score = 200
            //   894618               | mov                 dword ptr [esi + 0x18], eax
            //   85c0                 | test                eax, eax
            //   0f84c8000000         | je                  0xce
            //   a1????????           |                     
            //   85c0                 | test                eax, eax
            //   7522                 | jne                 0x24
            //   68????????           |                     

        $sequence_5 = { 750a 8d75ec e8???????? ebb8 b001 5e }
            // n = 6, score = 200
            //   750a                 | jne                 0xc
            //   8d75ec               | lea                 esi, [ebp - 0x14]
            //   e8????????           |                     
            //   ebb8                 | jmp                 0xffffffba
            //   b001                 | mov                 al, 1
            //   5e                   | pop                 esi

        $sequence_6 = { b8???????? 8bcb e8???????? 3bc6 0f8419ffffff 57 b8???????? }
            // n = 7, score = 200
            //   b8????????           |                     
            //   8bcb                 | mov                 ecx, ebx
            //   e8????????           |                     
            //   3bc6                 | cmp                 eax, esi
            //   0f8419ffffff         | je                  0xffffff1f
            //   57                   | push                edi
            //   b8????????           |                     

        $sequence_7 = { 05???????? 50 8d44247c 50 e8???????? 8b442420 2b442424 }
            // n = 7, score = 200
            //   05????????           |                     
            //   50                   | push                eax
            //   8d44247c             | lea                 eax, [esp + 0x7c]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b442420             | mov                 eax, dword ptr [esp + 0x20]
            //   2b442424             | sub                 eax, dword ptr [esp + 0x24]

        $sequence_8 = { 8b45fc c9 c20c00 55 8bec 56 8d4508 }
            // n = 7, score = 200
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   c9                   | leave               
            //   c20c00               | ret                 0xc
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   56                   | push                esi
            //   8d4508               | lea                 eax, [ebp + 8]

        $sequence_9 = { 0f849c000000 e8???????? 8bf8 85ff 0f8489000000 8b44240c 8b88f0000000 }
            // n = 7, score = 200
            //   0f849c000000         | je                  0xa2
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   85ff                 | test                edi, edi
            //   0f8489000000         | je                  0x8f
            //   8b44240c             | mov                 eax, dword ptr [esp + 0xc]
            //   8b88f0000000         | mov                 ecx, dword ptr [eax + 0xf0]

    condition:
        7 of them and filesize < 352256
}