rule win_retro_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.retro."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.retro"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { f3ab 498bec 4585e4 0f8e59010000 488b442428 f2440f1005???????? 498db5fc070000 }
            // n = 7, score = 200
            //   f3ab                 | movsd               qword ptr [ecx - 0x20], xmm0
            //   498bec               | dec                 edx
            //   4585e4               | mov                 dword ptr [ecx + eax + 0x7fe8], eax
            //   0f8e59010000         | dec                 eax
            //   488b442428           | mov                 eax, dword ptr [ecx - 0x10]
            //   f2440f1005????????     |     
            //   498db5fc070000       | movd                xmm0, dword ptr [edx - 0x14]

        $sequence_1 = { 4c8b442460 ffc0 4883c108 4883c204 4983c320 4981c100240000 4981c220290000 }
            // n = 7, score = 200
            //   4c8b442460           | inc                 ecx
            //   ffc0                 | movups              xmm1, xmmword ptr [eax + 0x78]
            //   4883c108             | inc                 ecx
            //   4883c204             | subps               xmm1, xmmword ptr [eax + 0x74]
            //   4983c320             | inc                 ecx
            //   4981c100240000       | movups              xmmword ptr [edx + eax - 4], xmm1
            //   4981c220290000       | movss               dword ptr [eax - 4], xmm3

        $sequence_2 = { 488bd9 e8???????? 85c0 7409 8b430c 4883c420 5b }
            // n = 7, score = 200
            //   488bd9               | movups              xmmword ptr [ebp], xmm0
            //   e8????????           |                     
            //   85c0                 | nop                 dword ptr [eax]
            //   7409                 | movd                xmm0, edi
            //   8b430c               | cvtdq2pd            xmm0, xmm0
            //   4883c420             | divsd               xmm6, xmm0
            //   5b                   | cvtsd2ss            xmm1, xmm6

        $sequence_3 = { 488b4f18 4533c0 e8???????? 488b4f20 8981a0120000 488b4720 8b88ec120000 }
            // n = 7, score = 200
            //   488b4f18             | mov                 eax, 0xffffffff
            //   4533c0               | dec                 eax
            //   e8????????           |                     
            //   488b4f20             | lea                 edx, [0x447a4]
            //   8981a0120000         | dec                 eax
            //   488b4720             | mov                 ecx, dword ptr [esp + 0x500]
            //   8b88ec120000         | call                dword ptr [esp + 0x538]

        $sequence_4 = { 664585d2 7964 4983c102 ffce 7852 498b942430560000 418b8c2428560000 }
            // n = 7, score = 200
            //   664585d2             | addsd               xmm4, xmm0
            //   7964                 | cvtps2pd            xmm0, xmm3
            //   4983c102             | inc                 ecx
            //   ffce                 | movups              xmm3, xmmword ptr [ecx - 0xc]
            //   7852                 | unpcklps            xmm2, xmm2
            //   498b942430560000     | unpcklps            xmm3, xmm3
            //   418b8c2428560000     | cvtps2pd            xmm1, xmm3

        $sequence_5 = { f30f5cd9 f30f108814100000 f30f59c4 f30f59dc f30f114018 f30f119818100000 f30f105810 }
            // n = 7, score = 200
            //   f30f5cd9             | mov                 ecx, edi
            //   f30f108814100000     | dec                 eax
            //   f30f59c4             | test                esi, esi
            //   f30f59dc             | je                  0x343
            //   f30f114018           | dec                 ecx
            //   f30f119818100000     | lea                 eax, [ecx + edi]
            //   f30f105810           | cmp                 dword ptr [eax + esi], ebx

        $sequence_6 = { 418bd5 488bcb 4869ff90140000 4903ff e8???????? 837b2401 750b }
            // n = 7, score = 200
            //   418bd5               | mov                 eax, 5
            //   488bcb               | dec                 eax
            //   4869ff90140000       | mov                 ecx, edi
            //   4903ff               | cmp                 dword ptr [ebx + 0x24], 1
            //   e8????????           |                     
            //   837b2401             | jne                 0x1033
            //   750b                 | dec                 eax

        $sequence_7 = { 0f14c0 450f14c0 0f5ac0 410f5ac8 f2410f58c2 f20f5ec8 f20f5ad1 }
            // n = 7, score = 200
            //   0f14c0               | arpl                word ptr [ebp + 0x3c], dx
            //   450f14c0             | inc                 edi
            //   0f5ac0               | movsx               eax, word ptr [ecx + edx*2]
            //   410f5ac8             | dec                 ecx
            //   f2410f58c2           | cmp                 edx, 8
            //   f20f5ec8             | jge                 0x1fd4
            //   f20f5ad1             | dec                 esp

        $sequence_8 = { 83c364 83bfa000000000 740b 488bd6 488bcf e8???????? 4533c9 }
            // n = 7, score = 200
            //   83c364               | test                eax, eax
            //   83bfa000000000       | je                  0x10ee
            //   740b                 | add                 esi, 6
            //   488bd6               | setne               dl
            //   488bcf               | cmp                 dword ptr [esp + 0x2c], 0
            //   e8????????           |                     
            //   4533c9               | je                  0x1103

        $sequence_9 = { f30f114f08 f30f104308 0f2f4708 768e ba01000000 eb89 f30f104304 }
            // n = 7, score = 200
            //   f30f114f08           | mov                 dword ptr [esp + 0x5628], ecx
            //   f30f104308           | dec                 eax
            //   0f2f4708             | lea                 ecx, [0xfffd32eb]
            //   768e                 | dec                 eax
            //   ba01000000           | add                 eax, edx
            //   eb89                 | dec                 ecx
            //   f30f104304           | mov                 dword ptr [esp + 0x5630], eax

    condition:
        7 of them and filesize < 1409024
}