rule win_revc2_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.revc2."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.revc2"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d4701 458bca 458bec 0f45f8 be01000000 8364244000 4183e21f }
            // n = 7, score = 100
            //   8d4701               | dec                 eax
            //   458bca               | mov                 ecx, dword ptr [ecx + 0x28]
            //   458bec               | inc                 esp
            //   0f45f8               | mov                 ecx, eax
            //   be01000000           | mov                 eax, edx
            //   8364244000           | inc                 ecx
            //   4183e21f             | and                 eax, ebx

        $sequence_1 = { e8???????? 498946b0 488bc3 49894500 486307 4c6bf068 410fb6842434010000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   498946b0             | dec                 eax
            //   488bc3               | mov                 ebx, eax
            //   49894500             | dec                 eax
            //   486307               | lea                 edx, [0x1f28bb]
            //   4c6bf068             | dec                 eax
            //   410fb6842434010000     | lea    ecx, [esp + 0x30]

        $sequence_2 = { 90 488d8d90000000 e8???????? 90 488d4dd0 e8???????? 90 }
            // n = 7, score = 100
            //   90                   | lea                 eax, [ecx + 1]
            //   488d8d90000000       | xor                 edx, edx
            //   e8????????           |                     
            //   90                   | mov                 dword ptr [ebx + 0x90], eax
            //   488d4dd0             | dec                 eax
            //   e8????????           |                     
            //   90                   | lea                 ecx, [ecx + ecx*2]

        $sequence_3 = { ff15???????? e9???????? 488b0e 488b11 0fb74214 a804 0f84ab010000 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   e9????????           |                     
            //   488b0e               | and                 ecx, edx
            //   488b11               | inc                 esp
            //   0fb74214             | lea                 eax, [edx - 0x275e197f]
            //   a804                 | inc                 ecx
            //   0f84ab010000         | and                 eax, edx

        $sequence_4 = { c5fe6f27 c5fe6f15???????? c5fe6f2d???????? c5fd71d404 c5fddbca c4e24d00d9 c5eddbc4 }
            // n = 7, score = 100
            //   c5fe6f27             | mov                 ecx, dword ptr [ebp + 0x130]
            //   c5fe6f15????????     |                     
            //   c5fe6f2d????????     |                     
            //   c5fd71d404           | mov                 edi, 0x8007000e
            //   c5fddbca             | mov                 ecx, eax
            //   c4e24d00d9           | test                eax, eax
            //   c5eddbc4             | je                  0x1533

        $sequence_5 = { eb12 4863c6 488d0c40 488b8388000000 488d04c8 895008 418d7701 }
            // n = 7, score = 100
            //   eb12                 | mov                 ebx, dword ptr [esp + 0x48]
            //   4863c6               | dec                 ecx
            //   488d0c40             | mov                 ecx, dword ptr [ebx]
            //   488b8388000000       | jmp                 0x99
            //   488d04c8             | inc                 ecx
            //   895008               | mov                 ecx, dword ptr [ebx + ebx*4 + 0x1f25e0]
            //   418d7701             | cmp                 dword ptr [esp + 0x70], 5

        $sequence_6 = { e8???????? 4c8b8424b8000000 498b38 4885ff 0f84fa010000 418bdd 4c8d0dca611200 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   4c8b8424b8000000     | lea                 eax, [0x1fbe15]
            //   498b38               | dec                 eax
            //   4885ff               | mov                 dword ptr [esp + 0x58], eax
            //   0f84fa010000         | dec                 eax
            //   418bdd               | mov                 ecx, dword ptr [edi + 0x38]
            //   4c8d0dca611200       | dec                 eax

        $sequence_7 = { 4c894dc0 4889542450 4889442458 4c895c2440 895c2430 895c2470 895da0 }
            // n = 7, score = 100
            //   4c894dc0             | mov                 dword ptr [ebp + edx*8], eax
            //   4889542450           | dec                 edx
            //   4889442458           | mov                 eax, dword ptr [ebp + ebp*8 - 8]
            //   4c895c2440           | dec                 eax
            //   895c2430             | mov                 dword ptr [ebp + edx*8 + 8], eax
            //   895c2470             | dec                 esp
            //   895da0               | cmp                 edi, ebx

        $sequence_8 = { e8???????? 90 4c8bc0 488d4d50 e8???????? 488bf8 488d542450 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   90                   | inc                 esp
            //   4c8bc0               | mov                 ecx, edx
            //   488d4d50             | mov                 edx, dword ptr [esp + 0x40]
            //   e8????????           |                     
            //   488bf8               | jmp                 0xd21
            //   488d542450           | mov                 edx, dword ptr [esp + 0x40]

        $sequence_9 = { e8???????? 488bc3 488b5c2450 488b7c2458 4883c440 5d c3 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488bc3               | mov                 ecx, dword ptr [edi + 0x18]
            //   488b5c2450           | movzx               ebx, al
            //   488b7c2458           | dec                 eax
            //   4883c440             | test                ecx, ecx
            //   5d                   | je                  0x260
            //   c3                   | movzx               ecx, al

    condition:
        7 of them and filesize < 5108736
}