rule win_revil_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.revil."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.revil"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33f6 6a00 6841db0100 ffb4356cffffff ffb43568ffffff }
            // n = 5, score = 3900
            //   33f6                 | xor                 esi, esi
            //   6a00                 | push                0
            //   6841db0100           | push                0x1db41
            //   ffb4356cffffff       | push                dword ptr [ebp + esi - 0x94]
            //   ffb43568ffffff       | push                dword ptr [ebp + esi - 0x98]

        $sequence_1 = { 50 8d8538feffff 50 ff7508 e8???????? ff7508 e8???????? }
            // n = 7, score = 3900
            //   50                   | push                eax
            //   8d8538feffff         | lea                 eax, [ebp - 0x1c8]
            //   50                   | push                eax
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     

        $sequence_2 = { 8b80c0000000 8b5d08 8945ec 8b4508 }
            // n = 4, score = 3900
            //   8b80c0000000         | mov                 eax, dword ptr [eax + 0xc0]
            //   8b5d08               | mov                 ebx, dword ptr [ebp + 8]
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

        $sequence_3 = { 0cc0 80c980 880437 884c3701 }
            // n = 4, score = 3900
            //   0cc0                 | or                  al, 0xc0
            //   80c980               | or                  cl, 0x80
            //   880437               | mov                 byte ptr [edi + esi], al
            //   884c3701             | mov                 byte ptr [edi + esi + 1], cl

        $sequence_4 = { 8365d000 807d0f2d 8b75f0 8975f4 7408 83ca02 }
            // n = 6, score = 3900
            //   8365d000             | and                 dword ptr [ebp - 0x30], 0
            //   807d0f2d             | cmp                 byte ptr [ebp + 0xf], 0x2d
            //   8b75f0               | mov                 esi, dword ptr [ebp - 0x10]
            //   8975f4               | mov                 dword ptr [ebp - 0xc], esi
            //   7408                 | je                  0xa
            //   83ca02               | or                  edx, 2

        $sequence_5 = { 4b 8955f8 e9???????? 837db400 }
            // n = 4, score = 3900
            //   4b                   | dec                 ebx
            //   8955f8               | mov                 dword ptr [ebp - 8], edx
            //   e9????????           |                     
            //   837db400             | cmp                 dword ptr [ebp - 0x4c], 0

        $sequence_6 = { 8bc2 33437c 33cf 3345fc 894b78 8bcb }
            // n = 6, score = 3900
            //   8bc2                 | mov                 eax, edx
            //   33437c               | xor                 eax, dword ptr [ebx + 0x7c]
            //   33cf                 | xor                 ecx, edi
            //   3345fc               | xor                 eax, dword ptr [ebp - 4]
            //   894b78               | mov                 dword ptr [ebx + 0x78], ecx
            //   8bcb                 | mov                 ecx, ebx

        $sequence_7 = { 3345e4 89417c 8bce f7d1 8bc2 234ddc }
            // n = 6, score = 3900
            //   3345e4               | xor                 eax, dword ptr [ebp - 0x1c]
            //   89417c               | mov                 dword ptr [ecx + 0x7c], eax
            //   8bce                 | mov                 ecx, esi
            //   f7d1                 | not                 ecx
            //   8bc2                 | mov                 eax, edx
            //   234ddc               | and                 ecx, dword ptr [ebp - 0x24]

        $sequence_8 = { 81ecf0040000 53 56 57 bf90000000 }
            // n = 5, score = 3900
            //   81ecf0040000         | sub                 esp, 0x4f0
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   bf90000000           | mov                 edi, 0x90

        $sequence_9 = { 57 33db 89b53cffffff 8d8540ffffff 43 }
            // n = 5, score = 3900
            //   57                   | push                edi
            //   33db                 | xor                 ebx, ebx
            //   89b53cffffff         | mov                 dword ptr [ebp - 0xc4], esi
            //   8d8540ffffff         | lea                 eax, [ebp - 0xc0]
            //   43                   | inc                 ebx

    condition:
        7 of them and filesize < 155794432
}