rule win_rhadamanthys_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.rhadamanthys."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rhadamanthys"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff7308 03c6 50 8b03 }
            // n = 4, score = 200
            //   ff7308               | push                dword ptr [ebx + 8]
            //   03c6                 | add                 eax, esi
            //   50                   | push                eax
            //   8b03                 | mov                 eax, dword ptr [ebx]

        $sequence_1 = { 8a01 84c0 7416 8b542408 69d293010001 }
            // n = 5, score = 200
            //   8a01                 | mov                 al, byte ptr [ecx]
            //   84c0                 | test                al, al
            //   7416                 | je                  0x18
            //   8b542408             | mov                 edx, dword ptr [esp + 8]
            //   69d293010001         | imul                edx, edx, 0x1000193

        $sequence_2 = { 33d0 41 89542408 ebe4 }
            // n = 4, score = 200
            //   33d0                 | xor                 edx, eax
            //   41                   | inc                 ecx
            //   89542408             | mov                 dword ptr [esp + 8], edx
            //   ebe4                 | jmp                 0xffffffe6

        $sequence_3 = { 7416 8b542408 69d293010001 0fb6c0 33d0 41 }
            // n = 6, score = 200
            //   7416                 | je                  0x18
            //   8b542408             | mov                 edx, dword ptr [esp + 8]
            //   69d293010001         | imul                edx, edx, 0x1000193
            //   0fb6c0               | movzx               eax, al
            //   33d0                 | xor                 edx, eax
            //   41                   | inc                 ecx

        $sequence_4 = { 8b542408 69d293010001 0fb6c0 33d0 41 89542408 ebe4 }
            // n = 7, score = 200
            //   8b542408             | mov                 edx, dword ptr [esp + 8]
            //   69d293010001         | imul                edx, edx, 0x1000193
            //   0fb6c0               | movzx               eax, al
            //   33d0                 | xor                 edx, eax
            //   41                   | inc                 ecx
            //   89542408             | mov                 dword ptr [esp + 8], edx
            //   ebe4                 | jmp                 0xffffffe6

        $sequence_5 = { 7416 8b542408 69d293010001 0fb6c0 33d0 }
            // n = 5, score = 200
            //   7416                 | je                  0x18
            //   8b542408             | mov                 edx, dword ptr [esp + 8]
            //   69d293010001         | imul                edx, edx, 0x1000193
            //   0fb6c0               | movzx               eax, al
            //   33d0                 | xor                 edx, eax

        $sequence_6 = { 84c0 7416 8b542408 69d293010001 0fb6c0 }
            // n = 5, score = 200
            //   84c0                 | test                al, al
            //   7416                 | je                  0x18
            //   8b542408             | mov                 edx, dword ptr [esp + 8]
            //   69d293010001         | imul                edx, edx, 0x1000193
            //   0fb6c0               | movzx               eax, al

        $sequence_7 = { 7416 8b542408 69d293010001 0fb6c0 33d0 41 89542408 }
            // n = 7, score = 200
            //   7416                 | je                  0x18
            //   8b542408             | mov                 edx, dword ptr [esp + 8]
            //   69d293010001         | imul                edx, edx, 0x1000193
            //   0fb6c0               | movzx               eax, al
            //   33d0                 | xor                 edx, eax
            //   41                   | inc                 ecx
            //   89542408             | mov                 dword ptr [esp + 8], edx

        $sequence_8 = { 84c0 7416 8b542408 69d293010001 0fb6c0 33d0 }
            // n = 6, score = 200
            //   84c0                 | test                al, al
            //   7416                 | je                  0x18
            //   8b542408             | mov                 edx, dword ptr [esp + 8]
            //   69d293010001         | imul                edx, edx, 0x1000193
            //   0fb6c0               | movzx               eax, al
            //   33d0                 | xor                 edx, eax

        $sequence_9 = { 84c0 7416 8b542408 69d293010001 }
            // n = 4, score = 200
            //   84c0                 | test                al, al
            //   7416                 | je                  0x18
            //   8b542408             | mov                 edx, dword ptr [esp + 8]
            //   69d293010001         | imul                edx, edx, 0x1000193

    condition:
        7 of them and filesize < 1111040
}