rule win_rhino_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.rhino."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rhino"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 3944240c 760a f71487 40 3b44240c 72f6 }
            // n = 6, score = 400
            //   3944240c             | cmp                 dword ptr [esp + 0xc], eax
            //   760a                 | jbe                 0xc
            //   f71487               | not                 dword ptr [edi + eax*4]
            //   40                   | inc                 eax
            //   3b44240c             | cmp                 eax, dword ptr [esp + 0xc]
            //   72f6                 | jb                  0xfffffff8

        $sequence_1 = { 8bc7 c1c806 33c8 8b44242c 33442420 23c7 3344242c }
            // n = 7, score = 400
            //   8bc7                 | mov                 eax, edi
            //   c1c806               | ror                 eax, 6
            //   33c8                 | xor                 ecx, eax
            //   8b44242c             | mov                 eax, dword ptr [esp + 0x2c]
            //   33442420             | xor                 eax, dword ptr [esp + 0x20]
            //   23c7                 | and                 eax, edi
            //   3344242c             | xor                 eax, dword ptr [esp + 0x2c]

        $sequence_2 = { 8d45d8 50 6a06 8bce e8???????? 6a00 6a01 }
            // n = 7, score = 400
            //   8d45d8               | lea                 eax, [ebp - 0x28]
            //   50                   | push                eax
            //   6a06                 | push                6
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   6a00                 | push                0
            //   6a01                 | push                1

        $sequence_3 = { 03c1 8b4c2420 83d500 894114 8b470c f7e0 }
            // n = 6, score = 400
            //   03c1                 | add                 eax, ecx
            //   8b4c2420             | mov                 ecx, dword ptr [esp + 0x20]
            //   83d500               | adc                 ebp, 0
            //   894114               | mov                 dword ptr [ecx + 0x14], eax
            //   8b470c               | mov                 eax, dword ptr [edi + 0xc]
            //   f7e0                 | mul                 eax

        $sequence_4 = { 8d45d0 50 e8???????? e8???????? c20800 8b5114 }
            // n = 6, score = 400
            //   8d45d0               | lea                 eax, [ebp - 0x30]
            //   50                   | push                eax
            //   e8????????           |                     
            //   e8????????           |                     
            //   c20800               | ret                 8
            //   8b5114               | mov                 edx, dword ptr [ecx + 0x14]

        $sequence_5 = { 83ec78 8d6c24fc a1???????? 33c5 894578 6a14 b8???????? }
            // n = 7, score = 400
            //   83ec78               | sub                 esp, 0x78
            //   8d6c24fc             | lea                 ebp, [esp - 4]
            //   a1????????           |                     
            //   33c5                 | xor                 eax, ebp
            //   894578               | mov                 dword ptr [ebp + 0x78], eax
            //   6a14                 | push                0x14
            //   b8????????           |                     

        $sequence_6 = { 53 53 6800000008 51 53 53 56 }
            // n = 7, score = 400
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   6800000008           | push                0x8000000
            //   51                   | push                ecx
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   56                   | push                esi

        $sequence_7 = { 68???????? 50 e8???????? 83c40c 8365fc00 8bce 50 }
            // n = 7, score = 400
            //   68????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8365fc00             | and                 dword ptr [ebp - 4], 0
            //   8bce                 | mov                 ecx, esi
            //   50                   | push                eax

        $sequence_8 = { 8b06 ff5048 85c0 0f849c000000 807c241006 0f8591000000 57 }
            // n = 7, score = 400
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   ff5048               | call                dword ptr [eax + 0x48]
            //   85c0                 | test                eax, eax
            //   0f849c000000         | je                  0xa2
            //   807c241006           | cmp                 byte ptr [esp + 0x10], 6
            //   0f8591000000         | jne                 0x97
            //   57                   | push                edi

        $sequence_9 = { 8b5528 0f1101 034c241c 836c242801 89442410 894c2414 758a }
            // n = 7, score = 400
            //   8b5528               | mov                 edx, dword ptr [ebp + 0x28]
            //   0f1101               | movups              xmmword ptr [ecx], xmm0
            //   034c241c             | add                 ecx, dword ptr [esp + 0x1c]
            //   836c242801           | sub                 dword ptr [esp + 0x28], 1
            //   89442410             | mov                 dword ptr [esp + 0x10], eax
            //   894c2414             | mov                 dword ptr [esp + 0x14], ecx
            //   758a                 | jne                 0xffffff8c

    condition:
        7 of them and filesize < 1288192
}