rule win_rhysida_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.rhysida."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rhysida"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4183c201 4883c108 4d8d3404 4889c5 4d89f4 49c1ec3c 4539d0 }
            // n = 7, score = 400
            //   4183c201             | mov                 edx, eax
            //   4883c108             | dec                 eax
            //   4d8d3404             | lea                 ecx, [eax + edx*8]
            //   4889c5               | dec                 eax
            //   4d89f4               | cmp                 dword ptr [ecx], 0
            //   49c1ec3c             | je                  0xd78
            //   4539d0               | inc                 ecx

        $sequence_1 = { 488b4510 8b4004 85c0 750a 488b4510 8b5520 895024 }
            // n = 7, score = 400
            //   488b4510             | mov                 ebp, esp
            //   8b4004               | dec                 eax
            //   85c0                 | sub                 esp, 0x30
            //   750a                 | dec                 eax
            //   488b4510             | mov                 dword ptr [ebp + 0x10], ecx
            //   8b5520               | mov                 dword ptr [ebp + 0x18], edx
            //   895024               | mov                 dword ptr [ebp - 4], 1

        $sequence_2 = { f30f5e45fc f30f1145f8 488b4518 f30f1000 f30f5945f8 f30f2cc0 89c2 }
            // n = 7, score = 400
            //   f30f5e45fc           | arpl                dx, cx
            //   f30f1145f8           | dec                 eax
            //   488b4518             | lea                 edx, [0x55558]
            //   f30f1000             | movzx               edx, byte ptr [ecx + edx]
            //   f30f5945f8           | movzx               edx, dl
            //   f30f2cc0             | dec                 eax
            //   89c2                 | arpl                dx, dx

        $sequence_3 = { 8d7802 430fb60c2a 43300c2b 448d6803 410fb62c12 450fb6043a 41302c13 }
            // n = 7, score = 400
            //   8d7802               | add                 eax, edx
            //   430fb60c2a           | mov                 eax, dword ptr [ebp + 0x80]
            //   43300c2b             | mov                 edx, eax
            //   448d6803             | dec                 eax
            //   410fb62c12           | lea                 eax, [0x5abbc]
            //   450fb6043a           | mov                 dword ptr [eax], edx
            //   41302c13             | dec                 eax

        $sequence_4 = { eb18 8b8598000000 898588000000 8b8594000000 898584000000 8b85b4000000 8d5001 }
            // n = 7, score = 400
            //   eb18                 | and                 edx, ebx
            //   8b8598000000         | dec                 ecx
            //   898588000000         | mov                 ebx, eax
            //   8b8594000000         | push                ebx
            //   898584000000         | dec                 eax
            //   8b85b4000000         | sub                 esp, 0x20
            //   8d5001               | dec                 eax

        $sequence_5 = { 41c1e818 46332483 4189e8 45332492 0fb6d4 44332491 4531e0 }
            // n = 7, score = 400
            //   41c1e818             | mov                 eax, 1
            //   46332483             | call                eax
            //   4189e8               | nop                 
            //   45332492             | dec                 eax
            //   0fb6d4               | mov                 eax, dword ptr [ebp + 0x20]
            //   44332491             | dec                 eax
            //   4531e0               | lea                 edx, [eax + 8]

        $sequence_6 = { 85d2 0f8f92050000 ba01000000 bd01000000 4531db 4d63cb 49beffffffffffffff0f }
            // n = 7, score = 400
            //   85d2                 | jne                 0x41a
            //   0f8f92050000         | dec                 eax
            //   ba01000000           | test                ecx, ecx
            //   bd01000000           | je                  0x3d3
            //   4531db               | dec                 eax
            //   4d63cb               | mov                 ecx, dword ptr [ebx + 0x1d8]
            //   49beffffffffffffff0f     | dec    eax

        $sequence_7 = { ffd0 c7850c11000000000000 c7850811000000000000 c7850411000000000000 c785dc0d000000000000 c785d80d000000000000 83bd4811000002 }
            // n = 7, score = 400
            //   ffd0                 | dec                 eax
            //   c7850c11000000000000     | mov    eax, dword ptr [ebp + 0x30]
            //   c7850811000000000000     | dec    eax
            //   c7850411000000000000     | add    eax, 4
            //   c785dc0d000000000000     | movss    xmm1, dword ptr [eax]
            //   c785d80d000000000000     | dec    eax
            //   83bd4811000002       | mov                 eax, dword ptr [ebp + 0x18]

        $sequence_8 = { c1e903 f348ab ff15???????? 83f812 7472 488b8b38020000 e8???????? }
            // n = 7, score = 400
            //   c1e903               | add                 eax, 1
            //   f348ab               | shl                 ebx, 8
            //   ff15????????         |                     
            //   83f812               | inc                 ecx
            //   7472                 | add                 eax, 1
            //   488b8b38020000       | inc                 esi
            //   e8????????           |                     

        $sequence_9 = { 4589542408 33460c 8b742444 418b2cb3 448b742458 81e5000000ff 478b1cb3 }
            // n = 7, score = 400
            //   4589542408           | dec                 esp
            //   33460c               | arpl                ax, cx
            //   8b742444             | je                  0xa27
            //   418b2cb3             | dec                 eax
            //   448b742458           | lea                 eax, [ecx + 9]
            //   81e5000000ff         | dec                 eax
            //   478b1cb3             | cmp                 eax, 0x66

    condition:
        7 of them and filesize < 2369536
}