rule win_rincux_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.rincux."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rincux"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 ff15???????? 89442418 8b442410 50 ff15???????? }
            // n = 6, score = 200
            //   50                   | push                eax
            //   ff15????????         |                     
            //   89442418             | mov                 dword ptr [esp + 0x18], eax
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_1 = { 83cafe 42 7534 8a4c2414 8a542410 c644245c01 }
            // n = 6, score = 200
            //   83cafe               | or                  edx, 0xfffffffe
            //   42                   | inc                 edx
            //   7534                 | jne                 0x36
            //   8a4c2414             | mov                 cl, byte ptr [esp + 0x14]
            //   8a542410             | mov                 dl, byte ptr [esp + 0x10]
            //   c644245c01           | mov                 byte ptr [esp + 0x5c], 1

        $sequence_2 = { 8b8c2494a00000 5f 5e 5d 33c0 5b }
            // n = 6, score = 200
            //   8b8c2494a00000       | mov                 ecx, dword ptr [esp + 0xa094]
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   33c0                 | xor                 eax, eax
            //   5b                   | pop                 ebx

        $sequence_3 = { 53 55 56 57 0f84ec150000 8b581c 85db }
            // n = 7, score = 200
            //   53                   | push                ebx
            //   55                   | push                ebp
            //   56                   | push                esi
            //   57                   | push                edi
            //   0f84ec150000         | je                  0x15f2
            //   8b581c               | mov                 ebx, dword ptr [eax + 0x1c]
            //   85db                 | test                ebx, ebx

        $sequence_4 = { bb06000000 8b04a8 8d7804 8b07 50 ff15???????? 83c704 }
            // n = 7, score = 200
            //   bb06000000           | mov                 ebx, 6
            //   8b04a8               | mov                 eax, dword ptr [eax + ebp*4]
            //   8d7804               | lea                 edi, [eax + 4]
            //   8b07                 | mov                 eax, dword ptr [edi]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   83c704               | add                 edi, 4

        $sequence_5 = { 50 68???????? 51 ffd6 8b15???????? 83c40c 8b049508a50210 }
            // n = 7, score = 200
            //   50                   | push                eax
            //   68????????           |                     
            //   51                   | push                ecx
            //   ffd6                 | call                esi
            //   8b15????????         |                     
            //   83c40c               | add                 esp, 0xc
            //   8b049508a50210       | mov                 eax, dword ptr [edx*4 + 0x1002a508]

        $sequence_6 = { 85c0 7477 ff15???????? 83f812 746c 8b6c2418 8b35???????? }
            // n = 7, score = 200
            //   85c0                 | test                eax, eax
            //   7477                 | je                  0x79
            //   ff15????????         |                     
            //   83f812               | cmp                 eax, 0x12
            //   746c                 | je                  0x6e
            //   8b6c2418             | mov                 ebp, dword ptr [esp + 0x18]
            //   8b35????????         |                     

        $sequence_7 = { 8d4c2424 8d5d1c 52 8d7d10 8d7518 51 53 }
            // n = 7, score = 200
            //   8d4c2424             | lea                 ecx, [esp + 0x24]
            //   8d5d1c               | lea                 ebx, [ebp + 0x1c]
            //   52                   | push                edx
            //   8d7d10               | lea                 edi, [ebp + 0x10]
            //   8d7518               | lea                 esi, [ebp + 0x18]
            //   51                   | push                ecx
            //   53                   | push                ebx

        $sequence_8 = { 33db 33ed 3bf0 57 89742410 89442414 }
            // n = 6, score = 200
            //   33db                 | xor                 ebx, ebx
            //   33ed                 | xor                 ebp, ebp
            //   3bf0                 | cmp                 esi, eax
            //   57                   | push                edi
            //   89742410             | mov                 dword ptr [esp + 0x10], esi
            //   89442414             | mov                 dword ptr [esp + 0x14], eax

        $sequence_9 = { 5b 5e 5d c20400 5e b8???????? }
            // n = 6, score = 200
            //   5b                   | pop                 ebx
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   c20400               | ret                 4
            //   5e                   | pop                 esi
            //   b8????????           |                     

    condition:
        7 of them and filesize < 392192
}