rule win_ripper_atm_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ripper_atm."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ripper_atm"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 51 8bcc 89a57cfdffff 68???????? e8???????? }
            // n = 5, score = 100
            //   51                   | push                ecx
            //   8bcc                 | mov                 ecx, esp
            //   89a57cfdffff         | mov                 dword ptr [ebp - 0x284], esp
            //   68????????           |                     
            //   e8????????           |                     

        $sequence_1 = { 2bc1 99 c745f818000000 f77df8 83c410 8945e8 85c9 }
            // n = 7, score = 100
            //   2bc1                 | sub                 eax, ecx
            //   99                   | cdq                 
            //   c745f818000000       | mov                 dword ptr [ebp - 8], 0x18
            //   f77df8               | idiv                dword ptr [ebp - 8]
            //   83c410               | add                 esp, 0x10
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   85c9                 | test                ecx, ecx

        $sequence_2 = { c7470411000000 897708 89770c 897710 c707???????? }
            // n = 5, score = 100
            //   c7470411000000       | mov                 dword ptr [edi + 4], 0x11
            //   897708               | mov                 dword ptr [edi + 8], esi
            //   89770c               | mov                 dword ptr [edi + 0xc], esi
            //   897710               | mov                 dword ptr [edi + 0x10], esi
            //   c707????????         |                     

        $sequence_3 = { c3 55 8bec 8b0d???????? 8b15???????? 8bc1 2bc2 }
            // n = 7, score = 100
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   8b0d????????         |                     
            //   8b15????????         |                     
            //   8bc1                 | mov                 eax, ecx
            //   2bc2                 | sub                 eax, edx

        $sequence_4 = { 8b4f3c 50 e8???????? 8b4f3c ff75fc 0fbec0 894744 }
            // n = 7, score = 100
            //   8b4f3c               | mov                 ecx, dword ptr [edi + 0x3c]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b4f3c               | mov                 ecx, dword ptr [edi + 0x3c]
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   0fbec0               | movsx               eax, al
            //   894744               | mov                 dword ptr [edi + 0x44], eax

        $sequence_5 = { 7516 8b7708 8b4610 3b02 0f8d8e000000 ff7514 }
            // n = 6, score = 100
            //   7516                 | jne                 0x18
            //   8b7708               | mov                 esi, dword ptr [edi + 8]
            //   8b4610               | mov                 eax, dword ptr [esi + 0x10]
            //   3b02                 | cmp                 eax, dword ptr [edx]
            //   0f8d8e000000         | jge                 0x94
            //   ff7514               | push                dword ptr [ebp + 0x14]

        $sequence_6 = { 8b4de8 3b4810 7d27 8b4e08 ff7514 80790d00 51 }
            // n = 7, score = 100
            //   8b4de8               | mov                 ecx, dword ptr [ebp - 0x18]
            //   3b4810               | cmp                 ecx, dword ptr [eax + 0x10]
            //   7d27                 | jge                 0x29
            //   8b4e08               | mov                 ecx, dword ptr [esi + 8]
            //   ff7514               | push                dword ptr [ebp + 0x14]
            //   80790d00             | cmp                 byte ptr [ecx + 0xd], 0
            //   51                   | push                ecx

        $sequence_7 = { 68???????? 53 ff15???????? 56 56 50 8945fc }
            // n = 7, score = 100
            //   68????????           |                     
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   56                   | push                esi
            //   56                   | push                esi
            //   50                   | push                eax
            //   8945fc               | mov                 dword ptr [ebp - 4], eax

        $sequence_8 = { 8bf9 50 e8???????? ff7518 8d45ec ff7514 8bcf }
            // n = 7, score = 100
            //   8bf9                 | mov                 edi, ecx
            //   50                   | push                eax
            //   e8????????           |                     
            //   ff7518               | push                dword ptr [ebp + 0x18]
            //   8d45ec               | lea                 eax, [ebp - 0x14]
            //   ff7514               | push                dword ptr [ebp + 0x14]
            //   8bcf                 | mov                 ecx, edi

        $sequence_9 = { 7409 6aff 53 50 e8???????? be???????? 56 }
            // n = 7, score = 100
            //   7409                 | je                  0xb
            //   6aff                 | push                -1
            //   53                   | push                ebx
            //   50                   | push                eax
            //   e8????????           |                     
            //   be????????           |                     
            //   56                   | push                esi

    condition:
        7 of them and filesize < 724992
}