rule win_risepro_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.risepro."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.risepro"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { eb04 32c0 eb02 b001 8be5 5d }
            // n = 6, score = 100
            //   eb04                 | jmp                 6
            //   32c0                 | xor                 al, al
            //   eb02                 | jmp                 4
            //   b001                 | mov                 al, 1
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp

        $sequence_1 = { e8???????? 50 8d4de4 e8???????? ebdc 8d4de4 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   50                   | push                eax
            //   8d4de4               | lea                 ecx, [ebp - 0x1c]
            //   e8????????           |                     
            //   ebdc                 | jmp                 0xffffffde
            //   8d4de4               | lea                 ecx, [ebp - 0x1c]

        $sequence_2 = { 8b5508 8d0c4a 8d5514 e8???????? }
            // n = 4, score = 100
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   8d0c4a               | lea                 ecx, [edx + ecx*2]
            //   8d5514               | lea                 edx, [ebp + 0x14]
            //   e8????????           |                     

        $sequence_3 = { 8995f0feffff b808000000 6bc800 8b95ccfeffff 8b840a8c000000 }
            // n = 5, score = 100
            //   8995f0feffff         | mov                 dword ptr [ebp - 0x110], edx
            //   b808000000           | mov                 eax, 8
            //   6bc800               | imul                ecx, eax, 0
            //   8b95ccfeffff         | mov                 edx, dword ptr [ebp - 0x134]
            //   8b840a8c000000       | mov                 eax, dword ptr [edx + ecx + 0x8c]

        $sequence_4 = { 8b4de8 0fb79180000000 52 8b4508 50 8b4de8 e8???????? }
            // n = 7, score = 100
            //   8b4de8               | mov                 ecx, dword ptr [ebp - 0x18]
            //   0fb79180000000       | movzx               edx, word ptr [ecx + 0x80]
            //   52                   | push                edx
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   50                   | push                eax
            //   8b4de8               | mov                 ecx, dword ptr [ebp - 0x18]
            //   e8????????           |                     

        $sequence_5 = { c745fc00000000 c745d888bd4100 8b4de8 51 8b55d8 52 8d4def }
            // n = 7, score = 100
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   c745d888bd4100       | mov                 dword ptr [ebp - 0x28], 0x41bd88
            //   8b4de8               | mov                 ecx, dword ptr [ebp - 0x18]
            //   51                   | push                ecx
            //   8b55d8               | mov                 edx, dword ptr [ebp - 0x28]
            //   52                   | push                edx
            //   8d4def               | lea                 ecx, [ebp - 0x11]

        $sequence_6 = { 8b55c8 8955b0 8d45d8 50 }
            // n = 4, score = 100
            //   8b55c8               | mov                 edx, dword ptr [ebp - 0x38]
            //   8955b0               | mov                 dword ptr [ebp - 0x50], edx
            //   8d45d8               | lea                 eax, [ebp - 0x28]
            //   50                   | push                eax

        $sequence_7 = { 8bc8 e8???????? 8945f8 e8???????? 8945f4 }
            // n = 5, score = 100
            //   8bc8                 | mov                 ecx, eax
            //   e8????????           |                     
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   e8????????           |                     
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax

        $sequence_8 = { 64a300000000 894dc4 8b4dc4 83c11c e8???????? }
            // n = 5, score = 100
            //   64a300000000         | mov                 dword ptr fs:[0], eax
            //   894dc4               | mov                 dword ptr [ebp - 0x3c], ecx
            //   8b4dc4               | mov                 ecx, dword ptr [ebp - 0x3c]
            //   83c11c               | add                 ecx, 0x1c
            //   e8????????           |                     

        $sequence_9 = { 2b45f0 3b45f4 7305 e8???????? 8a45fe }
            // n = 5, score = 100
            //   2b45f0               | sub                 eax, dword ptr [ebp - 0x10]
            //   3b45f4               | cmp                 eax, dword ptr [ebp - 0xc]
            //   7305                 | jae                 7
            //   e8????????           |                     
            //   8a45fe               | mov                 al, byte ptr [ebp - 2]

    condition:
        7 of them and filesize < 280576
}