rule win_roadsweep_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.roadsweep."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.roadsweep"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 89542404 e8???????? 3955cc 89c3 c745b800000000 }
            // n = 5, score = 100
            //   89542404             | mov                 dword ptr [esp + 4], edx
            //   e8????????           |                     
            //   3955cc               | cmp                 dword ptr [ebp - 0x34], edx
            //   89c3                 | mov                 ebx, eax
            //   c745b800000000       | mov                 dword ptr [ebp - 0x48], 0

        $sequence_1 = { e9???????? c7442404???????? c7042404010000 e8???????? 83ec08 e9???????? c744240404010000 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   c7442404????????     |                     
            //   c7042404010000       | mov                 dword ptr [esp], 0x104
            //   e8????????           |                     
            //   83ec08               | sub                 esp, 8
            //   e9????????           |                     
            //   c744240404010000     | mov                 dword ptr [esp + 4], 0x104

        $sequence_2 = { 8b45e8 85d2 0f885d010000 85d2 0f8ea6010000 }
            // n = 5, score = 100
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]
            //   85d2                 | test                edx, edx
            //   0f885d010000         | js                  0x163
            //   85d2                 | test                edx, edx
            //   0f8ea6010000         | jle                 0x1ac

        $sequence_3 = { 00d2 8b5d08 83d903 8db534ffffff c744240c00000000 29f9 baffffffff }
            // n = 7, score = 100
            //   00d2                 | add                 dl, dl
            //   8b5d08               | mov                 ebx, dword ptr [ebp + 8]
            //   83d903               | sbb                 ecx, 3
            //   8db534ffffff         | lea                 esi, [ebp - 0xcc]
            //   c744240c00000000     | mov                 dword ptr [esp + 0xc], 0
            //   29f9                 | sub                 ecx, edi
            //   baffffffff           | mov                 edx, 0xffffffff

        $sequence_4 = { 56 ba01000000 53 83ec50 8b7508 8d742600 8dbc2700000000 }
            // n = 7, score = 100
            //   56                   | push                esi
            //   ba01000000           | mov                 edx, 1
            //   53                   | push                ebx
            //   83ec50               | sub                 esp, 0x50
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   8d742600             | lea                 esi, [esi]
            //   8dbc2700000000       | lea                 edi, [edi]

        $sequence_5 = { c744241000000000 89542404 893424 e8???????? 8bbd6cffffff }
            // n = 5, score = 100
            //   c744241000000000     | mov                 dword ptr [esp + 0x10], 0
            //   89542404             | mov                 dword ptr [esp + 4], edx
            //   893424               | mov                 dword ptr [esp], esi
            //   e8????????           |                     
            //   8bbd6cffffff         | mov                 edi, dword ptr [ebp - 0x94]

        $sequence_6 = { c745cc04100800 891424 e8???????? 83ec04 85c0 }
            // n = 5, score = 100
            //   c745cc04100800       | mov                 dword ptr [ebp - 0x34], 0x81004
            //   891424               | mov                 dword ptr [esp], edx
            //   e8????????           |                     
            //   83ec04               | sub                 esp, 4
            //   85c0                 | test                eax, eax

        $sequence_7 = { e8???????? 891c24 8d9578fbffff 89542404 c68578fbffff25 c68579fbffff73 c6857afbffff63 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   891c24               | mov                 dword ptr [esp], ebx
            //   8d9578fbffff         | lea                 edx, [ebp - 0x488]
            //   89542404             | mov                 dword ptr [esp + 4], edx
            //   c68578fbffff25       | mov                 byte ptr [ebp - 0x488], 0x25
            //   c68579fbffff73       | mov                 byte ptr [ebp - 0x487], 0x73
            //   c6857afbffff63       | mov                 byte ptr [ebp - 0x486], 0x63

        $sequence_8 = { 890424 e8???????? 89b564ffffff 31c9 48 899d6cffffff }
            // n = 6, score = 100
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   89b564ffffff         | mov                 dword ptr [ebp - 0x9c], esi
            //   31c9                 | xor                 ecx, ecx
            //   48                   | dec                 eax
            //   899d6cffffff         | mov                 dword ptr [ebp - 0x94], ebx

        $sequence_9 = { 3d???????? 7207 3d???????? 7216 }
            // n = 4, score = 100
            //   3d????????           |                     
            //   7207                 | jb                  9
            //   3d????????           |                     
            //   7216                 | jb                  0x18

    condition:
        7 of them and filesize < 160768
}