rule win_rokrat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.rokrat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rokrat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 e8???????? 6a04 33c0 }
            // n = 4, score = 800
            //   50                   | push                eax
            //   e8????????           |                     
            //   6a04                 | push                4
            //   33c0                 | xor                 eax, eax

        $sequence_1 = { 668945c0 e8???????? c645fc03 8b45bc }
            // n = 4, score = 800
            //   668945c0             | mov                 word ptr [ebp - 0x40], ax
            //   e8????????           |                     
            //   c645fc03             | mov                 byte ptr [ebp - 4], 3
            //   8b45bc               | mov                 eax, dword ptr [ebp - 0x44]

        $sequence_2 = { 50 e8???????? 6a10 33c0 }
            // n = 4, score = 800
            //   50                   | push                eax
            //   e8????????           |                     
            //   6a10                 | push                0x10
            //   33c0                 | xor                 eax, eax

        $sequence_3 = { 50 e8???????? 8d8e0c010000 8d4550 3bc8 }
            // n = 5, score = 800
            //   50                   | push                eax
            //   e8????????           |                     
            //   8d8e0c010000         | lea                 ecx, [esi + 0x10c]
            //   8d4550               | lea                 eax, [ebp + 0x50]
            //   3bc8                 | cmp                 ecx, eax

        $sequence_4 = { 0fb7c1 50 0fb74208 c1e910 51 50 0fb74212 }
            // n = 7, score = 800
            //   0fb7c1               | movzx               eax, cx
            //   50                   | push                eax
            //   0fb74208             | movzx               eax, word ptr [edx + 8]
            //   c1e910               | shr                 ecx, 0x10
            //   51                   | push                ecx
            //   50                   | push                eax
            //   0fb74212             | movzx               eax, word ptr [edx + 0x12]

        $sequence_5 = { 50 ff15???????? e8???????? 40 }
            // n = 4, score = 800
            //   50                   | push                eax
            //   ff15????????         |                     
            //   e8????????           |                     
            //   40                   | inc                 eax

        $sequence_6 = { 50 e8???????? 6a18 33c0 }
            // n = 4, score = 800
            //   50                   | push                eax
            //   e8????????           |                     
            //   6a18                 | push                0x18
            //   33c0                 | xor                 eax, eax

        $sequence_7 = { 68???????? e8???????? 837e1408 7204 8b06 eb02 8bc6 }
            // n = 7, score = 800
            //   68????????           |                     
            //   e8????????           |                     
            //   837e1408             | cmp                 dword ptr [esi + 0x14], 8
            //   7204                 | jb                  6
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   eb02                 | jmp                 4
            //   8bc6                 | mov                 eax, esi

        $sequence_8 = { 50 e8???????? 8d8edc000000 8d4520 }
            // n = 4, score = 800
            //   50                   | push                eax
            //   e8????????           |                     
            //   8d8edc000000         | lea                 ecx, [esi + 0xdc]
            //   8d4520               | lea                 eax, [ebp + 0x20]

        $sequence_9 = { ff15???????? 50 e8???????? 59 6a64 }
            // n = 5, score = 300
            //   ff15????????         |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   6a64                 | push                0x64

        $sequence_10 = { 897dfc e8???????? 68???????? 8d4dd8 e8???????? }
            // n = 5, score = 200
            //   897dfc               | mov                 dword ptr [ebp - 4], edi
            //   e8????????           |                     
            //   68????????           |                     
            //   8d4dd8               | lea                 ecx, [ebp - 0x28]
            //   e8????????           |                     

        $sequence_11 = { 89442410 7e34 8d9b00000000 56 }
            // n = 4, score = 100
            //   89442410             | mov                 dword ptr [esp + 0x10], eax
            //   7e34                 | jle                 0x36
            //   8d9b00000000         | lea                 ebx, [ebx]
            //   56                   | push                esi

        $sequence_12 = { 89442410 807c244400 7558 85db 7454 68d3010000 }
            // n = 6, score = 100
            //   89442410             | mov                 dword ptr [esp + 0x10], eax
            //   807c244400           | cmp                 byte ptr [esp + 0x44], 0
            //   7558                 | jne                 0x5a
            //   85db                 | test                ebx, ebx
            //   7454                 | je                  0x56
            //   68d3010000           | push                0x1d3

        $sequence_13 = { 89442410 80f925 0f859d030000 3808 }
            // n = 4, score = 100
            //   89442410             | mov                 dword ptr [esp + 0x10], eax
            //   80f925               | cmp                 cl, 0x25
            //   0f859d030000         | jne                 0x3a3
            //   3808                 | cmp                 byte ptr [eax], cl

        $sequence_14 = { 89442410 7c7c 8b7758 8b9f8c000000 81c630010000 }
            // n = 5, score = 100
            //   89442410             | mov                 dword ptr [esp + 0x10], eax
            //   7c7c                 | jl                  0x7e
            //   8b7758               | mov                 esi, dword ptr [edi + 0x58]
            //   8b9f8c000000         | mov                 ebx, dword ptr [edi + 0x8c]
            //   81c630010000         | add                 esi, 0x130

        $sequence_15 = { 89442410 7e19 68110b0000 68???????? }
            // n = 4, score = 100
            //   89442410             | mov                 dword ptr [esp + 0x10], eax
            //   7e19                 | jle                 0x1b
            //   68110b0000           | push                0xb11
            //   68????????           |                     

    condition:
        7 of them and filesize < 2932736
}